/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.toolregistry;

import com.apple.transporter.toolregistry.api.ToolRegistry;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import org.osgi.framework.Bundle;

public class ToolRegistryImpl
implements ToolRegistry {
    private final Map<String, String> registry = new TreeMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getRegisteredTools() {
        ToolRegistryImpl toolRegistryImpl = this;
        synchronized (toolRegistryImpl) {
            return Collections.unmodifiableMap(this.registry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTool(String toolName, String toolVersion) {
        ToolRegistryImpl toolRegistryImpl = this;
        synchronized (toolRegistryImpl) {
            this.registry.put(toolName, toolVersion);
        }
    }

    public boolean registerToolsInBundleFromProperties(Bundle bundle, String propertiesFileName) {
        if (null == bundle) {
            return false;
        }
        URL url = bundle.getResource(propertiesFileName);
        if (null == url) {
            return false;
        }
        Properties props = new Properties();
        try {
            props.load(url.openConnection().getInputStream());
        }
        catch (IOException iox) {
            return false;
        }
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String tool = String.format("%s (%s-%s)", key, bundle.getSymbolicName(), bundle.getVersion());
            this.registerTool(tool, value.toString());
        }));
        return true;
    }
}

