/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.streaming;

import com.apple.transporter.streaming.api.StreamableContent;
import com.apple.transporter.streaming.api.StreamableContentKey;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class StreamingUtil {
    private StreamingUtil() {
    }

    public static File getServerFile(@Nonnull StreamableContent streamableContent) {
        File serverRoot = new File("$MZCD_STREAMING_ROOT");
        return new File(serverRoot, streamableContent.getFileName());
    }

    public static Map<String, Object> streamingInfoMap(@Nonnull StreamableContent streamableContent) {
        Long lval;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String tmp = streamableContent.getChecksumAlgorithm();
        if (null != tmp) {
            result.put(StreamableContentKey.CHECKSUM_ALGORITHM.name(), tmp);
        }
        if (null != (tmp = streamableContent.getChecksumValue())) {
            result.put(StreamableContentKey.CHECKSUM_VALUE.name(), tmp);
        }
        if (null != (tmp = streamableContent.getContentEncoding())) {
            result.put(StreamableContentKey.CONTENT_ENCODING.name(), tmp);
        }
        if (null != (lval = streamableContent.getContentLength())) {
            result.put(StreamableContentKey.CONTENT_LENGTH.name(), lval);
        }
        if (null != (tmp = streamableContent.getContentTransferEncoding())) {
            result.put(StreamableContentKey.CONTENT_TRANSFER_ENCODING.name(), tmp);
        }
        if (null != (tmp = streamableContent.getContentType())) {
            result.put(StreamableContentKey.CONTENT_TYPE.name(), tmp);
        }
        result.put(StreamableContentKey.FILE_NAME.name(), streamableContent.getFileName());
        result.put(StreamableContentKey.FILE_PATH.name(), StreamingUtil.getServerFile(streamableContent).getPath());
        lval = streamableContent.getUncompressedContentLength();
        if (null != lval) {
            result.put(StreamableContentKey.UNCOMPRESSED_CONTENT_LENGTH.name(), lval);
        }
        return result;
    }
}

