/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.streaming;

import com.apple.transporter.streaming.StreamingUtil;
import com.apple.transporter.streaming.api.StreamableContent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class StreamableFile
implements StreamableContent,
JSONAware,
JSONStreamAware {
    private File file;
    private String checksumAlgorithm;
    private String checksumValue;
    private String contentEncoding;
    private String contentTransferEncoding;
    private String contentType;
    private Long uncompressedContentLength;
    private Long maximumFileSize;

    public void setFile(File file) {
        this.file = file;
    }

    public void setChecksumAlgorithm(String checksumAlgorithm) {
        this.checksumAlgorithm = checksumAlgorithm;
    }

    public String getChecksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    public void setChecksumValue(String checksumValue) {
        this.checksumValue = checksumValue;
    }

    public String getChecksumValue() {
        return this.checksumValue;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public Long getContentLength() {
        return this.file.length();
    }

    public void setContentTransferEncoding(String contentTransferEncoding) {
        this.contentTransferEncoding = contentTransferEncoding;
    }

    public String getContentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFilePath() {
        return this.file.getAbsolutePath();
    }

    public String getFileName() {
        return this.file.getName();
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public void setUncompressedContentLength(long uncompressedContentLength) {
        this.uncompressedContentLength = uncompressedContentLength;
    }

    public Long getMaximumFileSize() {
        return this.maximumFileSize;
    }

    public void setMaximumFileSize(long maximumFileSize) {
        this.maximumFileSize = maximumFileSize;
    }

    public Long getUncompressedContentLength() {
        return this.uncompressedContentLength;
    }

    public String toJSONString() {
        return JSONObject.toJSONString(StreamingUtil.streamingInfoMap(this));
    }

    public void writeJSONString(Writer out) throws IOException {
        JSONObject.writeJSONString(StreamingUtil.streamingInfoMap(this), (Writer)out);
    }
}

