/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.stats;

import com.apple.transporter.stats.api.Statistic;
import com.apple.transporter.stats.api.StatisticCollector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class StatisticCollectorImpl
implements StatisticCollector {
    private final LinkedList<TimedStatistic> stats;
    private final LinkedList<ExternalStatistic> externalStats;
    private final TimedStatistic startStop = new TimedStatistic("totalTime");
    private int maxOpNameLength = -1;

    public StatisticCollectorImpl() {
        this.stats = new LinkedList();
        this.externalStats = new LinkedList();
        this.maxOpNameLength = this.startStop.name.length();
    }

    public Statistic startOperationReturningPreviousStatistic(String name) {
        TimedStatistic previousStat = this.stats.peekLast();
        TimedStatistic stat = new TimedStatistic(name);
        this.stats.add(stat);
        this.maxOpNameLength = Math.max(this.maxOpNameLength, name.length());
        if (null != previousStat && !previousStat.finished) {
            previousStat.whenFinishedNanoTime = stat.whenStartedNanoTime;
            previousStat.finished = true;
            return previousStat;
        }
        return this.startStop;
    }

    public void stopCurrent() {
        TimedStatistic current = this.stats.peekLast();
        if (null != current && !current.finished) {
            current.whenFinishedNanoTime = System.nanoTime();
            current.finished = true;
        }
    }

    public void stop() {
        if (this.startStop.finished) {
            return;
        }
        this.startStop.whenFinishedNanoTime = System.nanoTime();
        this.startStop.finished = true;
        TimedStatistic previousStat = this.stats.peekLast();
        if (null != previousStat && !previousStat.finished) {
            previousStat.whenFinishedNanoTime = this.startStop.whenFinishedNanoTime;
            previousStat.finished = true;
        }
    }

    public long durationInNanoSecondsSinceStarted() {
        return this.startStop.getDurationInNanoSecondsToNow();
    }

    public void addExternalTiming(@Nonnull String name, double time, int count) {
        this.externalStats.add(new ExternalStatistic(name, time, count));
    }

    public List<Map<String, Object>> getResults() {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Statistic statistic : this.stats) {
            if (!statistic.isFinished()) continue;
            result.add(this.statisticToMap(statistic));
        }
        for (Statistic statistic : this.externalStats) {
            if (!statistic.isFinished()) continue;
            result.add(this.statisticToMap(statistic));
        }
        return result;
    }

    public void dumpStatistics(StringBuilder sb) {
        sb.append("========================================================================\n");
        for (Statistic statistic : this.stats) {
            this.dumpStatistic(statistic, sb, this.maxOpNameLength, false);
        }
        sb.append("========================================================================\n");
        this.dumpStatistic(this.startStop, sb, this.maxOpNameLength, true);
        if (!this.externalStats.isEmpty()) {
            sb.append("============================ external tools ============================\n");
            for (Statistic statistic : this.externalStats) {
                this.dumpStatistic(statistic, sb, this.maxOpNameLength, false);
            }
        }
        sb.append("========================================================================\n");
    }

    private Map<String, Object> statisticToMap(Statistic statistic) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("method", statistic.getName());
        result.put("duration", new Double(statistic.getDurationInSeconds()));
        result.put("count", new Long(statistic.getCount()));
        return result;
    }

    private void dumpStatistic(Statistic statistic, StringBuilder sb, int maxLength, boolean suppressCount) {
        String nameFormat = "%-" + maxLength + "s";
        String formattedName = String.format(nameFormat, statistic.getName());
        String secs = String.format("%1$10.3f secs", statistic.getDurationInSeconds());
        if (suppressCount) {
            sb.append('\t').append(formattedName).append(' ').append(secs).append('\n');
        } else {
            String count = String.format("%5d", statistic.getCount());
            sb.append('\t').append(formattedName).append(' ').append(secs).append(' ').append(count).append('\n');
        }
    }

    public static class ExternalStatistic
    implements Statistic {
        private final String name;
        private final double seconds;
        private final long count;

        public ExternalStatistic(String name, double seconds, long count) {
            this.name = name;
            this.seconds = seconds;
            this.count = count;
        }

        public String getName() {
            return this.name;
        }

        public long getCount() {
            return this.count;
        }

        public double getDurationInSeconds() {
            return this.seconds;
        }

        public boolean isFinished() {
            return true;
        }
    }

    public static class TimedStatistic
    implements Statistic {
        private final String name;
        public final long whenStartedNanoTime;
        private long whenFinishedNanoTime = 0L;
        private boolean finished = false;

        private TimedStatistic(String name) {
            this.name = name;
            this.whenStartedNanoTime = System.nanoTime();
        }

        public long getWhenFinishedNanoTime() {
            return this.whenFinishedNanoTime;
        }

        public String getName() {
            return this.name;
        }

        public long getCount() {
            return 1L;
        }

        public double getDurationInSeconds() {
            return (double)this.getDurationInNanoSeconds() / 1.0E9;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public long getDurationInNanoSecondsToNanoTime(long systemNanoTime) {
            if (!this.finished) {
                return systemNanoTime - this.whenStartedNanoTime;
            }
            return this.whenFinishedNanoTime - this.whenStartedNanoTime;
        }

        public long getDurationInNanoSecondsToNow() {
            if (!this.finished) {
                return System.nanoTime() - this.whenStartedNanoTime;
            }
            return this.whenFinishedNanoTime - this.whenStartedNanoTime;
        }

        public long getDurationInNanoSeconds() {
            if (!this.finished) {
                throw new IllegalStateException("operation was not marked as finished");
            }
            return this.whenFinishedNanoTime - this.whenStartedNanoTime;
        }
    }
}

