/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.osgi;

import com.apple.jingle.leghorn.software.SoftwareDescriberLocationSpecFactoryUtil;
import com.apple.jingle.leghorn.software.SoftwareSupportService;
import com.apple.transporter.Application;
import com.apple.transporter.WebService;
import com.apple.transporter.log.Logger;
import com.apple.transporter.mediatoolkit.SoftwareDescriberLocatorFactory;
import com.apple.transporter.osgi.TransporterConnectionServiceLauncher;
import com.apple.transporter.transport.AsperaTransport;
import com.apple.transporter.transport.service.AsperaSupportService;
import com.apple.transporter.util.ConfigurationUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class TransporterService {
    private final BundleContext bundleContext;

    public TransporterService(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public int run(String[] argv) throws Exception {
        try {
            return this.start(argv, null);
        }
        catch (Exception ex) {
            Logger.error("Error occurred while running Transporter Service", ex);
            throw ex;
        }
    }

    public int start(String[] argv, String version) throws Exception {
        ServiceReference serviceReference;
        ServiceReference[] serviceReferences;
        if (null != version) {
            WebService.TXVersionNumberString = version;
        }
        try {
            serviceReferences = this.bundleContext.getServiceReferences(AsperaSupportService.class.getName(), null);
            serviceReference = ConfigurationUtil.getServiceReference(version, serviceReferences);
            AsperaTransport.asperaSupportService = (AsperaSupportService)this.bundleContext.getService(serviceReference);
        }
        catch (InvalidSyntaxException e) {
            Logger.extreme("error setting up Aspera Support Service");
        }
        try {
            System.setProperty(SoftwareDescriberLocationSpecFactoryUtil.SOFTWARE_DESCRIPTION_LOCATION_SPEC_FACTORY_PROPERTY, SoftwareDescriberLocatorFactory.class.getName());
            serviceReferences = this.bundleContext.getServiceReferences(SoftwareSupportService.class.getName(), null);
            serviceReference = ConfigurationUtil.getServiceReference(version, serviceReferences);
            SoftwareDescriberLocatorFactory.softwareSupportService = (SoftwareSupportService)this.bundleContext.getService(serviceReference);
        }
        catch (InvalidSyntaxException e) {
            Logger.extreme("error setting up Software Support Service");
        }
        Application.setConnectionServiceLauncher(new TransporterConnectionServiceLauncher(this.bundleContext));
        try {
            int result = Application.begin(argv);
            return result;
        }
        catch (Exception ex) {
            Logger.error("Error occurred while running Transporter Service", ex);
            return -1;
        }
    }
}

