/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.osgi;

import com.apple.transporter.commlink.api.ConnectionServiceLauncher;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class TransporterConnectionServiceLauncher
implements ConnectionServiceLauncher {
    private final BundleContext bundleContext;

    public TransporterConnectionServiceLauncher(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void launch() {
        String port = System.getProperty("CSPort");
        if (null == port) {
            return;
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("port", Integer.parseInt(port));
        String poolSize = System.getProperty("CSPoolSize", "1");
        ((Dictionary)properties).put("poolSize", Integer.parseInt(poolSize));
        String authToken = System.getProperty("CSAuthToken");
        if (null != authToken) {
            ((Dictionary)properties).put("authToken", authToken);
        }
        this.updateConfigurationProperties(properties);
    }

    public void halt() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        this.updateConfigurationProperties(properties);
    }

    private void updateConfigurationProperties(Dictionary<String, Object> properties) {
        try {
            ServiceReference sr = this.bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
            ConfigurationAdmin admin = (ConfigurationAdmin)this.bundleContext.getService(sr);
            Configuration configuration = admin.getConfiguration("com.apple.transporter.commlink", null);
            configuration.update(properties);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

