/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.osgi;

import com.apple.transporter.Application;
import com.apple.transporter.osgi.TransporterService;
import com.apple.transporter.osgi.TransporterServiceFactory;
import com.apple.transporter.stats.StatisticCollectorImpl;
import com.apple.transporter.stats.api.StatisticCollector;
import com.apple.transporter.toolregistry.ToolRegistryImpl;
import com.apple.transporter.toolregistry.api.ToolRegistry;
import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;

public class TransporterBundleActivator
implements BundleActivator {
    public void start(BundleContext bundleContext) throws Exception {
        this.registerStatisticCollectorService(bundleContext);
        this.registerToolRegistryService(bundleContext);
        this.registerService(bundleContext);
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }

    private void registerService(BundleContext bundleContext) {
        bundleContext.registerService(TransporterService.class, (ServiceFactory)new TransporterServiceFactory(), new Hashtable());
    }

    private void registerStatisticCollectorService(BundleContext bundleContext) {
        StatisticCollectorImpl statisticCollector = new StatisticCollectorImpl();
        Application.setStatisticCollector(statisticCollector);
        bundleContext.registerService(StatisticCollector.class, (Object)statisticCollector, new Hashtable());
    }

    private void registerToolRegistryService(BundleContext bundleContext) {
        ToolRegistryImpl registry = new ToolRegistryImpl();
        bundleContext.registerService(ToolRegistry.class, (Object)registry, new Hashtable());
        registry.registerToolsInBundleFromProperties(bundleContext.getBundle(), "itmstransporter.tool.properties");
        String javaVersion = System.getProperty("java.version");
        if (null != javaVersion) {
            String javaHome = System.getProperty("java.home");
            registry.registerTool("java (" + javaHome + ")", javaVersion);
        }
        Application.setToolRegistry(registry);
    }
}

