/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.status;

import com.apple.transporter.Application;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.option.AppleIdOption;
import com.apple.transporter.operation.option.MultipleIdOption;
import com.apple.transporter.operation.option.VendorIdOption;
import com.apple.transporter.operation.status.FetchStatusByAppleId;
import com.apple.transporter.operation.status.FetchStatusByMultipleAppleId;
import com.apple.transporter.operation.status.FetchStatusByMultipleVendorId;
import com.apple.transporter.operation.status.FetchStatusByVendorId;
import com.apple.transporter.operation.status.ServerSideOutputFormatter;
import com.apple.transporter.util.XMLUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class StatusFetcher {
    final boolean shouldReturnStateIDs;
    private final String logMessage;
    final boolean isStatusAllRequest;
    final WebService service;
    private XMLUtil.XMLTag errors;
    private List<ServerSideOutputFormatter> results = new ArrayList<ServerSideOutputFormatter>();

    StatusFetcher(boolean shouldReturnStateIDs, String logMessage, boolean isStatusAllRequest, WebService service) {
        this.shouldReturnStateIDs = shouldReturnStateIDs;
        this.logMessage = logMessage;
        this.isStatusAllRequest = isStatusAllRequest;
        this.service = service;
    }

    public abstract boolean fetchStatus();

    public static StatusFetcher createFetcher(boolean isStatusAllRequest, WebService service) {
        boolean shouldReturnStateIDs = Boolean.getBoolean("status.display.codes");
        String vendorIds = MultipleIdOption.vendorIdentifiers();
        String appleIds = MultipleIdOption.appleIdentifiers();
        String vendorId = VendorIdOption.vendorIdentifier();
        String appleId = AppleIdOption.appleIdentifier();
        if (vendorIds != null && vendorIds.trim().length() != 0) {
            return new FetchStatusByMultipleVendorId(shouldReturnStateIDs, " for the vendor identifiers " + vendorIds, isStatusAllRequest, service, vendorIds);
        }
        if (appleIds != null && appleIds.trim().length() != 0) {
            return new FetchStatusByMultipleAppleId(shouldReturnStateIDs, " for the apple identifiers " + appleIds, isStatusAllRequest, service, appleIds);
        }
        if (vendorId != null && vendorId.trim().length() != 0) {
            return new FetchStatusByVendorId(shouldReturnStateIDs, " for the vendor identifier " + vendorId, isStatusAllRequest, service, vendorId);
        }
        if (appleId != null && appleId.trim().length() != 0) {
            return new FetchStatusByAppleId(shouldReturnStateIDs, " for the apple identifier " + appleId, isStatusAllRequest, service, appleId);
        }
        throw new IllegalArgumentException("Please specify an appropriate identifier for status mode.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean fetchStatusForVendorId(final String vendorId) {
        ServerSideOutputFormatter formatter = new ServerSideOutputFormatter(this.logMessage);
        boolean wasSuccessful = true;
        try {
            if (this.isStatusAllRequest) {
                Logger.info("Retrieving the complete upload status" + this.logMessage);
            } else {
                Logger.info("Retrieving upload status" + this.logMessage);
            }
            Map<String, Object> returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, Object>>(){

                @Override
                public void setNetworkIsReachable(boolean isReachable) {
                }

                @Override
                public Map<String, Object> invoke() {
                    return StatusFetcher.this.service.uploadStatusForVendorId(vendorId, Application.shouldHidePassword(), StatusFetcher.this.isStatusAllRequest, StatusFetcher.this.shouldReturnStateIDs);
                }
            });
            if (returnValue == null) {
                formatter.logErrorMessage("Unable to get the upload status.");
                boolean bl = false;
                return bl;
            }
            if (Application.doesContainSOAPError(returnValue)) {
                formatter.logErrorMessage("Unable to get the upload status.");
                formatter.logReturnedErrors(returnValue);
                boolean bl = false;
                return bl;
            }
            formatter.setServerResponse(returnValue);
            this.results.add(formatter);
        }
        catch (Throwable t) {
            wasSuccessful = false;
            String msg = null;
            msg = this.isStatusAllRequest ? "Error while retrieving the complete upload status" + this.logMessage + ".  Exception's message: " + t.getMessage() : "Error while retrieving the upload status" + this.logMessage + ".  Exception's message: " + t.getMessage();
            formatter.logErrorMessage(msg);
        }
        finally {
            formatter.complete();
        }
        return wasSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean fetchStatusForAppleId(final String appleId) {
        ServerSideOutputFormatter formatter = new ServerSideOutputFormatter(this.logMessage);
        boolean wasSuccessful = true;
        try {
            if (this.isStatusAllRequest) {
                Logger.info("Retrieving the complete upload status" + this.logMessage);
            } else {
                Logger.info("Retrieving upload status" + this.logMessage);
            }
            Map<String, Object> returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, Object>>(){

                @Override
                public void setNetworkIsReachable(boolean isReachable) {
                }

                @Override
                public Map<String, Object> invoke() {
                    return StatusFetcher.this.service.uploadStatusForAppleId(appleId, Application.shouldHidePassword(), StatusFetcher.this.isStatusAllRequest, StatusFetcher.this.shouldReturnStateIDs);
                }
            });
            if (returnValue == null) {
                formatter.logErrorMessage("Unable to get the upload status.");
                boolean bl = false;
                return bl;
            }
            if (Application.doesContainSOAPError(returnValue)) {
                formatter.logErrorMessage("Unable to get the upload status.");
                formatter.logReturnedErrors(returnValue);
                boolean bl = false;
                return bl;
            }
            formatter.setServerResponse(returnValue);
            this.results.add(formatter);
        }
        catch (Throwable t) {
            wasSuccessful = false;
            String msg = null;
            msg = this.isStatusAllRequest ? "Error while retrieving the complete upload status" + formatter.getLogMessage() + ".  Exception's message: " + t.getMessage() : "Error while retrieving the upload status" + formatter.getLogMessage() + ".  Exception's message: " + t.getMessage();
            formatter.logErrorMessage(msg);
        }
        finally {
            formatter.complete();
        }
        return wasSuccessful;
    }

    private XMLUtil.XMLTag errorsTag() {
        if (this.errors == null) {
            this.errors = new XMLUtil.XMLTag("errors", 1);
        }
        return this.errors;
    }

    void logErrorMessage(String msg) {
        if (Application.shouldGenerateXML()) {
            XMLUtil.generateLogTagAndAddToParent(Logger.Level.Error, msg, this.errorsTag());
        } else {
            Logger.error(msg);
        }
    }

    void logReturnedErrors(Map<String, Object> returnValue) {
        if (Application.shouldGenerateXML()) {
            Application.displaySOAPErrorMessages(returnValue, this.errorsTag(), 2, false);
        } else {
            Application.displaySOAPErrorMessages(returnValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean complete() {
        boolean wasSuccessful = true;
        for (ServerSideOutputFormatter formatter : this.results) {
            try {
                wasSuccessful = formatter.format();
            }
            catch (Throwable t) {
                wasSuccessful = false;
                String msg = null;
                msg = this.isStatusAllRequest ? "Error while retrieving the complete upload status" + formatter.getLogMessage() + ".  Exception's message: " + t.getMessage() : "Error while retrieving the upload status" + formatter.getLogMessage() + ".  Exception's message: " + t.getMessage();
                formatter.logErrorMessage(msg);
            }
            finally {
                formatter.complete();
            }
            Logger.essential("");
        }
        if (this.errors != null) {
            String xml = this.errors.marshall();
            Application.writeXML(xml);
        }
        return wasSuccessful;
    }

    void logReturnedWarnings(Map<String, Object> returnValue) {
        if (returnValue.containsKey(System.getProperty("warningsKey"))) {
            if (Application.shouldGenerateXML()) {
                XMLUtil.XMLTag warnings = new XMLUtil.XMLTag("warnings", 1);
                Application.displaySOAPWarningMessagesIfNeededInXML(returnValue, warnings, 2);
                String xml = warnings.marshall();
                Application.writeXML(xml);
            } else {
                Application.displayWarningMessages();
            }
        }
    }

    void logReturnedInfoMessages(Map<String, Object> returnValue) {
        if (returnValue.containsKey(System.getProperty("infoMessagesKey"))) {
            if (Application.shouldGenerateXML()) {
                XMLUtil.XMLTag infoMessages = new XMLUtil.XMLTag("infoMessages", 1);
                Application.displaySOAPInfoMessagesIfNeededInXML(returnValue, infoMessages, 2);
                String xml = infoMessages.marshall();
                Application.writeXML(xml);
            } else {
                Application.displayInfoMessages();
            }
        }
    }

    boolean checkServerResponse(Map<String, Object> returnValue) {
        if (returnValue == null) {
            this.logErrorMessage("Unable to get the upload status.");
            return false;
        }
        if (Application.doesContainSOAPError(returnValue)) {
            this.logErrorMessage("Unable to get the upload status.");
            this.logReturnedErrors(returnValue);
            return false;
        }
        this.logReturnedWarnings(returnValue);
        this.logReturnedInfoMessages(returnValue);
        Application.displayWarningMessages();
        Application.displayInfoMessages();
        return true;
    }
}

