/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.status;

import com.apple.transporter.Application;
import com.apple.transporter.log.Logger;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.StreamUtil;
import com.apple.transporter.util.StringUtil;
import com.apple.transporter.util.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ServerSideOutputFormatter {
    private final String logMessage;
    private String textFromServer;
    private XMLUtil.XMLTag errors;
    private Map<String, Object> serverResponse;

    public ServerSideOutputFormatter(String logMessage) {
        this.logMessage = logMessage;
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public void setServerResponse(Map<String, Object> serverResponse) {
        this.serverResponse = serverResponse;
    }

    public boolean format() {
        this.logReturnedWarnings(this.serverResponse);
        this.logReturnedInfoMessages(this.serverResponse);
        Application.displayWarningMessages();
        Application.displayInfoMessages();
        Map checksummedBlob = (Map)this.serverResponse.get(System.getProperty("formattedStatusKey"));
        if (checksummedBlob == null || checksummedBlob.isEmpty()) {
            this.logErrorMessage("There is no status information" + this.logMessage);
            return false;
        }
        String checksumKey = System.getProperty("checksummedBlobChecksumKey");
        String gzipContentKey = System.getProperty("checksummedBlobGzipContentKey");
        try {
            String formattedOutput = StreamUtil.base64GzipToString((String)checksummedBlob.get(gzipContentKey));
            byte[] hash = FileUtil.md5(new ByteArrayInputStream(formattedOutput.getBytes("UTF-8")));
            String checksum = StringUtil.byteArrayToHexString(hash);
            if (!checksum.equalsIgnoreCase((String)checksummedBlob.get(checksumKey))) {
                this.logErrorMessage("Checksum of status information returned by Apple's web service operation does not match expected checksum.");
                return false;
            }
            String[] textParts = formattedOutput.split("\n");
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(textParts));
            list.removeAll(Arrays.asList(""));
            this.textFromServer = "\n" + StringUtils.join(list, (String)"\n");
            return true;
        }
        catch (IOException errio) {
            this.logErrorMessageWithException("Unable to decompress status.", errio);
            return false;
        }
        catch (NoSuchAlgorithmException e) {
            this.logErrorMessage("MD5 isn't supported by this platform.");
            return false;
        }
    }

    private void logReturnedWarnings(Map<String, Object> returnValue) {
        if (returnValue.containsKey(System.getProperty("warningsKey"))) {
            if (Application.shouldGenerateXML()) {
                XMLUtil.XMLTag warnings = new XMLUtil.XMLTag("warnings", 1);
                Application.displaySOAPWarningMessagesIfNeededInXML(returnValue, warnings, 2);
                String xml = warnings.marshall();
                Application.writeXML(xml);
            } else {
                Application.displayWarningMessages();
            }
        }
    }

    private void logReturnedInfoMessages(Map<String, Object> returnValue) {
        if (returnValue.containsKey(System.getProperty("infoMessagesKey"))) {
            if (Application.shouldGenerateXML()) {
                XMLUtil.XMLTag infoMessages = new XMLUtil.XMLTag("infoMessages", 1);
                Application.displaySOAPInfoMessagesIfNeededInXML(returnValue, infoMessages, 2);
                String xml = infoMessages.marshall();
                Application.writeXML(xml);
            } else {
                Application.displayInfoMessages();
            }
        }
    }

    public void complete() {
        if (this.textFromServer != null) {
            Logger.essential(this.textFromServer);
        }
        if (this.errors != null) {
            String xml = this.errors.marshall();
            Application.writeXML(xml);
        }
    }

    private XMLUtil.XMLTag errorsTag() {
        if (this.errors == null) {
            this.errors = new XMLUtil.XMLTag("errors", 1);
        }
        return this.errors;
    }

    public void logErrorMessage(String msg) {
        if (Application.shouldGenerateXML()) {
            XMLUtil.generateLogTagAndAddToParent(Logger.Level.Error, msg, this.errorsTag());
        } else {
            Logger.error(msg);
        }
    }

    public void logErrorMessageWithException(String msg, Exception re) {
        if (Application.shouldGenerateXML()) {
            XMLUtil.generateLogTagAndAddToParent(Logger.Level.Error, msg, this.errorsTag());
        } else {
            Logger.error(msg);
        }
    }

    public void logReturnedErrors(Map<String, Object> returnValue) {
        if (Application.shouldGenerateXML()) {
            Application.displaySOAPErrorMessages(returnValue, this.errorsTag(), 2, false);
        } else {
            Application.displaySOAPErrorMessages(returnValue);
        }
    }
}

