/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.status;

import com.apple.transporter.Application;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.operation.status.StatusFetcher;
import java.util.Map;

public class FetchStatusByMultipleVendorId
extends StatusFetcher {
    private final String vendorIds;

    FetchStatusByMultipleVendorId(boolean shouldReturnStateIDs, String logMessage, boolean isStatusAllRequest, WebService service, String vendorIds) {
        super(shouldReturnStateIDs, logMessage, isStatusAllRequest, service);
        this.vendorIds = vendorIds;
    }

    @Override
    public boolean fetchStatus() {
        Map<String, Object> returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, Object>>(){

            @Override
            public void setNetworkIsReachable(boolean isReachable) {
            }

            @Override
            public Map<String, Object> invoke() {
                return FetchStatusByMultipleVendorId.this.service.uploadStatusVendorIds(FetchStatusByMultipleVendorId.this.vendorIds, Application.shouldHidePassword());
            }
        });
        if (!this.checkServerResponse(returnValue)) {
            return false;
        }
        Object[] parsedVendorIds = (Object[])returnValue.get(System.getProperty("VendorIdsKey"));
        if (parsedVendorIds == null) {
            this.logErrorMessage("Unable to get the upload status.");
            return false;
        }
        boolean response = true;
        for (Object parsedVendorId : parsedVendorIds) {
            boolean singleResponse = this.fetchStatusForVendorId(parsedVendorId.toString());
            response = response && singleResponse;
        }
        return response;
    }
}

