/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.status;

import com.apple.transporter.Application;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.operation.status.StatusFetcher;
import java.util.Map;

public class FetchStatusByMultipleAppleId
extends StatusFetcher {
    private final String appleIds;

    FetchStatusByMultipleAppleId(boolean shouldReturnStateIDs, String logMessage, boolean isStatusAllRequest, WebService service, String appleIds) {
        super(shouldReturnStateIDs, logMessage, isStatusAllRequest, service);
        this.appleIds = appleIds;
    }

    @Override
    public boolean fetchStatus() {
        Map<String, Object> returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, Object>>(){

            @Override
            public void setNetworkIsReachable(boolean isReachable) {
            }

            @Override
            public Map<String, Object> invoke() {
                return FetchStatusByMultipleAppleId.this.service.uploadStatusAppleIds(FetchStatusByMultipleAppleId.this.appleIds, Application.shouldHidePassword());
            }
        });
        if (!this.checkServerResponse(returnValue)) {
            return false;
        }
        Object[] parsedAppleIds = (Object[])returnValue.get(System.getProperty("AppleIdsKey"));
        if (parsedAppleIds == null) {
            this.logErrorMessage("Unable to get the upload status.");
            return false;
        }
        boolean response = true;
        for (Object parsedAppleId : parsedAppleIds) {
            boolean singleResponse = this.fetchStatusForAppleId(parsedAppleId.toString());
            response = response && singleResponse;
        }
        return response;
    }
}

