/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.log.VerifyProgressReporter;
import com.apple.transporter.operation.option.EnumeratedValueOption;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;

public class VerifyProgressOption
extends EnumeratedValueOption {
    private static final String[] ENUMERATED_VALUES = new String[]{"text", "json"};
    private VerifyProgressReporter vpr;

    public VerifyProgressOption(VerifyProgressReporter aReporter) throws IllegalArgumentException {
        super("vp", ENUMERATED_VALUES, "The -vp option displays the progress of the verify stage.  Valid parameters are 'text' and 'json'.");
        this.vpr = aReporter;
    }

    public VerifyProgressOption(VerifyProgressReporter aReporter, String description) throws IllegalArgumentException {
        super("vp", ENUMERATED_VALUES, description);
        this.vpr = aReporter;
    }

    @Override
    public void process(CommandLine commandLine) {
        super.process(commandLine);
        if (commandLine.hasOption(this.getOpt())) {
            int index = Arrays.asList(ENUMERATED_VALUES).indexOf(commandLine.getOptionValue(this.getOpt()).toLowerCase());
            VerifyProgressReporter.setVerifyProgressState(index == -1 ? 0 : index);
        }
    }
}

