/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.operation.option.BaseOption;

public class VendorIdOption
extends BaseOption {
    private static final long serialVersionUID = -4878697729324545557L;

    public VendorIdOption(Variant variant) throws IllegalArgumentException {
        super(variant.opt, true, variant.description);
    }

    public static String vendorIdentifier() {
        String vendorID = System.getProperty(Variant.VendorIdentifier.opt);
        if (vendorID == null || vendorID.length() == 0) {
            vendorID = System.getProperty(Variant.Generic.opt);
        }
        return vendorID;
    }

    public static enum Variant {
        Generic("vendor_id", "The -vendor_id option value specifies the vendor identifier to use."),
        LookupMetadata("vendor_id", "The -vendor_id option value specifies the vendor identifier used when generating the metadata XML for the content known by Apple. You cannot use this option with -apple_id, -apple_ids, or -vendor_ids option."),
        QueryTickets("vendor_id", "The -vendor_id option value specifies the vendor identifier used when generating the tickets XML for the content known by Apple. You cannot use this option with -apple_id, -apple_ids, or -vendor_ids option."),
        Status("vendor_id", "The -vendor_id option value is used to get the status information for packages uploaded with that vendor identifier. You cannot use this option with -apple_id, -apple_ids, or -vendor_ids option."),
        QCDownload("vendor_id", "The -vendor_id option value is used to specify the QC to download."),
        VendorIdentifier("vendor_identifier", "The -vendor_identifier option value specifies the vendor identifier to use.");

        String opt;
        String description;

        private Variant(String opt, String description) {
            this.opt = opt;
            this.description = description;
        }
    }
}

