/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.operation.option.AuthenticationOption;
import com.apple.transporter.operation.option.DSTokenOption;
import com.apple.transporter.operation.option.Hsa2HeadersOption;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.Validatable;
import org.apache.commons.cli.CommandLine;

public class UsernameOption
extends AuthenticationOption
implements Validatable {
    private static final long serialVersionUID = 3629454253484023092L;
    static final String NAME = "u";

    public UsernameOption() throws IllegalArgumentException {
        super(NAME, true, "The -u option specifies your username.");
    }

    @Override
    public void validate(CommandLine commandLine) throws OptionValidationException {
        if (UsernameOption.usernameWasGiven()) {
            return;
        }
        if (UsernameOption.authenticationIsRequired() && !DSTokenOption.dsTokenWasGiven() && !Hsa2HeadersOption.hsa2headersWereGiven()) {
            throw new OptionValidationException("The u option must have a non-empty value.");
        }
    }

    @Override
    public boolean shouldValidateMissingOption(CommandLine commandLine) {
        return UsernameOption.authenticationIsRequired() && !commandLine.hasOption(this.getOpt()) && !commandLine.hasOption("hsa2headers") && !commandLine.hasOption("dsToken");
    }

    public static boolean usernameWasGiven() {
        String username = UsernameOption.username();
        return username != null && !username.trim().isEmpty();
    }

    public static String username() {
        return System.getProperty(NAME);
    }
}

