/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.Validatable;
import com.apple.transporter.transport.TransportType;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.lang3.StringUtils;

public class TransportOption
extends BaseOption
implements Validatable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "t";
    private Variant variant;

    public TransportOption(Variant variant) {
        super(NAME, true, "The -t option specifies the delivery method you want to use. You can specify one of the following values: Aspera, Signiant, or DAV." + variant.extraDescription);
        if (variant == Variant.Upload || variant == Variant.Diagnostic) {
            int numArgs = 0;
            for (TransportType type : TransportType.values()) {
                if (!type.isChainable()) continue;
                ++numArgs;
            }
            this.setArgs(numArgs);
            this.setValueSeparator(',');
        }
        this.variant = variant;
    }

    @Override
    public void validate(CommandLine commandLine) throws OptionValidationException {
        this.variant.validate(this, commandLine);
    }

    public static enum Variant {
        Upload(" You may also specify a comma-separated list of any combination of these values to indicate that Transporter use any transport option that succeeds in the order specified. If you do not specify a value, Transporter uses the default delivery method order."),
        Diagnostic(""),
        Generic(""){

            @Override
            public void validate(Option option, CommandLine commandLine) throws OptionValidationException {
                String value = commandLine.getOptionValue(option.getOpt());
                try {
                    if (TransportType.valueOf(value).isChainable()) {
                        return;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                throw new OptionValidationException("Unknown transport specified: " + value);
            }
        };

        String extraDescription;

        private Variant(String extraDescription) {
            this.extraDescription = extraDescription;
        }

        public void validate(Option option, CommandLine commandLine) throws OptionValidationException {
            String[] values = option.getValues();
            if (values.length == 1) {
                try {
                    TransportType.valueOf(values[0]);
                }
                catch (IllegalArgumentException unknownTransport) {
                    throw new OptionValidationException("Unknown transport specified: " + values[0]);
                }
                if (this == Upload && TransportType.valueOf(values[0]).isThrottleCapable() && System.getProperty("k") == null) {
                    throw new OptionValidationException("Transport '" + values[0] + "' requires option -" + "k");
                }
            } else {
                ArrayList<String> actualValues = new ArrayList<String>();
                for (String value : values) {
                    try {
                        TransportType type = TransportType.valueOf(value);
                        if (type.isChainable()) {
                            actualValues.add(value);
                            continue;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (value == null || value.trim().isEmpty()) continue;
                    throw new OptionValidationException("Unknown transport specified: " + value);
                }
                System.setProperty(TransportOption.NAME, StringUtils.join(actualValues, (char)','));
            }
        }
    }
}

