/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.Application;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.Validatable;
import com.apple.transporter.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.cli.CommandLine;

public class SummaryFileOption
extends BaseOption
implements Validatable {
    public SummaryFileOption() {
        super("summaryFile", true);
    }

    @Override
    public void validate(CommandLine commandLine) throws OptionValidationException {
        try {
            String summaryFileWritePath = commandLine.getOptionValue(this.getOpt());
            File writePathFile = new File(FileUtil.absolutePathForPath(summaryFileWritePath));
            if (writePathFile.exists() && writePathFile.isDirectory()) {
                throw new OptionValidationException("Please specify a valid filename for the summary file.");
            }
            if (writePathFile.exists()) {
                throw new OptionValidationException("The specified summary file path already exists.  Please specify a filename that does not already exist.");
            }
            File writePathDir = (writePathFile = new File(writePathFile.getAbsolutePath())).getParentFile();
            if (!writePathDir.exists()) {
                throw new OptionValidationException("Path does not exist.  Please specify a valid path for the summary file.");
            }
            if (!writePathDir.canWrite() || writePathFile.exists() && !writePathFile.canWrite()) {
                throw new OptionValidationException("Cannot create summary file; permission denied.");
            }
            Application.setShouldWriteSummaryToFile(true);
            Application.setSummaryFileWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(writePathFile), "UTF-8"));
        }
        catch (IOException e) {
            Logger.error("Error configuring summary file.", e);
        }
    }
}

