/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.Validatable;
import com.apple.transporter.util.TransportUtil;
import org.apache.commons.cli.CommandLine;

public class SizeOption
extends BaseOption
implements Validatable {
    public SizeOption() {
        super("size", true, "The -size option value specifies the size of the test package to send to Apple's servers.  The size may be specified as bytes with no suffix, kilobytes with a 'K' suffix, megabytes with a 'M' suffix and gigabytes with a 'G' suffix.  If not specified the default value of '10M' (10 megabytes) is used.  Note that 'transferTest' mode is only available for DAV and Signiant transports.");
    }

    @Override
    public void validate(CommandLine commandLine) throws OptionValidationException {
        String sizeSpec = commandLine.getOptionValue(this.getOpt());
        if (sizeSpec != null) {
            try {
                TransportUtil.sizeSpecToLong(sizeSpec);
            }
            catch (NumberFormatException e) {
                throw new OptionValidationException("Please specify a valid test transfer package size.");
            }
        }
    }
}

