/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.Validatable;
import org.apache.commons.cli.CommandLine;

public class SearchLocaleOption
extends BaseOption
implements Validatable {
    private static final long serialVersionUID = -1244598613939496490L;
    private static final String OPTION_NAME = "searchLocale";

    public SearchLocaleOption() {
        super(OPTION_NAME, true, "The -searchLocale option value specifies the locale(s) codes to search.  The option may be specified multiple times or once with the locale codes separated by a comma.");
        this.setRequired(false);
    }

    @Override
    public void process(CommandLine commandLine) {
        String[] values = commandLine.getOptionValues(this.getOpt());
        if (values != null) {
            StringBuilder sb = new StringBuilder();
            for (String v : values) {
                String[] split;
                for (String splitV : split = v.split(",")) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(splitV);
                }
            }
            System.setProperty(OPTION_NAME, sb.toString());
        }
    }

    @Override
    public void validate(CommandLine commandLine) throws OptionValidationException {
        if (commandLine.hasOption("m")) {
            String mode = System.getProperty("m");
            if (null == mode) {
                mode = commandLine.getOptionValue("m");
            }
            if (!mode.equals("lookupArtist")) {
                throw new OptionValidationException("searchLocale option is not valid for the mode: " + mode);
            }
        }
    }

    public static String searchLocale() {
        return System.getProperty(OPTION_NAME);
    }
}

