/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.operation.option.EnumeratedValueOption;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.SchemaOption;
import com.apple.transporter.operation.option.Validatable;
import org.apache.commons.cli.CommandLine;

public class SchemaTypeOption
extends EnumeratedValueOption
implements Validatable {
    private static final long serialVersionUID = -6454726351071468714L;
    public static final String NAME = "schemaType";
    private static final String STRICT = "strict";
    private static final String TRANSITIONAL = "transitional";

    public SchemaTypeOption() {
        super(NAME, new String[]{STRICT, TRANSITIONAL}, "The -schemaType option value specifies the type of schema to retrieve and must be either 'strict' or 'transitional'.");
    }

    @Override
    public boolean shouldValidateMissingOption(CommandLine commandLine) {
        return commandLine.hasOption("schema");
    }

    @Override
    public void validate(CommandLine commandLine) throws OptionValidationException {
        String schemaName = commandLine.getOptionValue("schema");
        if (SchemaOption.isStaticSchema(schemaName) && !SchemaOption.supportsSchemaType(schemaName)) {
            if (null != commandLine.getOptionValue(NAME)) {
                throw new OptionValidationException("The schemaType option is not valid for the schema: " + schemaName);
            }
            return;
        }
        super.validate(commandLine);
    }
}

