/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.operation.option.BaseOption;

public class SchemaOption
extends BaseOption {
    private static final long serialVersionUID = 2938347755780052333L;
    public static final String NAME = "schema";

    public SchemaOption() {
        super(NAME, true, "The -schema option value specifies the schema to retrieve from Apple and print to console output, e.g. 'film5.1'");
        this.setRequired(true);
    }

    public static String getStaticSchemaExtension() {
        String schemaName = SchemaOption.getSchemaValue();
        StaticSchema schema = StaticSchema.byName(schemaName);
        if (null != schema) {
            return schema.extension;
        }
        return null;
    }

    public static boolean isStaticSchema() {
        return SchemaOption.isStaticSchema(SchemaOption.getSchemaValue());
    }

    public static boolean isStaticSchema(String schemaName) {
        StaticSchema schema = StaticSchema.byName(schemaName);
        return null != schema;
    }

    public static boolean supportsSchemaType() {
        return SchemaOption.supportsSchemaType(SchemaOption.getSchemaValue());
    }

    public static boolean supportsSchemaType(String schemaName) {
        StaticSchema schema = StaticSchema.byName(schemaName);
        if (null != schema) {
            return schema.supportsSchemaType;
        }
        return true;
    }

    public static String getSchemaValue() {
        return System.getProperty(NAME);
    }

    private static enum StaticSchema {
        JP_ITT_V2("jp-itt-v2", ".rnc", false);

        private final String name;
        private final String extension;
        private final boolean supportsSchemaType;

        private StaticSchema(String name, String extension, boolean supportsSchemaType) {
            this.name = name;
            this.extension = extension;
            this.supportsSchemaType = supportsSchemaType;
        }

        private static StaticSchema byName(String schemaName) {
            for (StaticSchema schema : StaticSchema.values()) {
                if (!schema.name.equals(schemaName)) continue;
                return schema;
            }
            return null;
        }
    }
}

