/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.operation.option.BaseOption;

public class ProviderNameOption
extends BaseOption {
    private static final long serialVersionUID = 2991032141615019277L;
    private static boolean providerIsRequired;

    public ProviderNameOption(Variant variant, boolean required) {
        super(variant.opt, true, "The -" + variant.opt + " option specifies the provider's short name.");
        super.setRequired(required);
        ProviderNameOption.setProviderIsRequired(required);
        this.setMaxArgumentValues(1);
    }

    public ProviderNameOption(Variant variant) {
        this(variant, variant == Variant.Long);
    }

    private static void setProviderIsRequired(boolean required) {
        providerIsRequired = required;
    }

    public static String providerName() {
        return System.getProperty(Variant.Short.opt, System.getProperty(Variant.Long.opt));
    }

    public static boolean wasProviderNameGiven() {
        String shortName = ProviderNameOption.providerName();
        return shortName != null && shortName.trim().length() != 0;
    }

    public static boolean providerIsRequired() {
        return providerIsRequired;
    }

    public static enum Variant {
        Short("s"),
        Long("provider");

        String opt;

        private Variant(String opt) {
            this.opt = opt;
        }
    }
}

