/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.operation.option.AuthSessionIdOption;
import com.apple.transporter.operation.option.AuthSharedSecretOption;
import com.apple.transporter.operation.option.AuthenticationOption;
import com.apple.transporter.operation.option.DSTokenOption;
import com.apple.transporter.operation.option.Hsa2HeadersOption;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.UsernameOption;
import com.apple.transporter.operation.option.Validatable;
import java.io.Console;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;

public class PasswordOption
extends AuthenticationOption
implements Validatable {
    private static final long serialVersionUID = -6377379711472668081L;
    private static final String NAME = "p";

    public PasswordOption() throws IllegalArgumentException {
        super(NAME, true, "The -p option specifies your password. Add the -p option without a password to have the system prompt for one.");
        this.setOptionalArg(true);
    }

    @Override
    public void validate(CommandLine commandLine) throws OptionValidationException {
        String password = System.getProperty(NAME);
        if (password != null && !password.trim().isEmpty()) {
            return;
        }
        if (this.isPasswordRequired(commandLine)) {
            throw new OptionValidationException("The password must have a non-empty value.");
        }
    }

    private boolean isPasswordRequired(CommandLine commandLine) {
        boolean optionFlagProvided;
        boolean hasUsernameValue;
        String username = commandLine.getOptionValue("u");
        boolean bl = hasUsernameValue = null != username && username.trim().length() > 0;
        return (hasUsernameValue || UsernameOption.usernameWasGiven() || PasswordOption.authenticationIsRequired()) && PasswordOption.shouldProvidePassword() && (optionFlagProvided = commandLine.hasOption(this.getOpt()));
    }

    @Override
    public boolean shouldValidateMissingOption(CommandLine commandLine) {
        return !commandLine.hasOption(this.getOpt());
    }

    @Override
    public void process(CommandLine commandLine) {
        String password = commandLine.getOptionValue(this.getOpt());
        if (password != null && password.trim().length() > 0) {
            super.process(commandLine);
        } else if (this.isPasswordRequired(commandLine)) {
            this.readPasswordFromConsole();
        }
    }

    private void readPasswordFromConsole() {
        char[] pass;
        Console console = System.console();
        if (console != null && (pass = console.readPassword("%s's password: ", UsernameOption.username())) != null && pass.length != 0) {
            String password = new String(pass);
            System.setProperty(NAME, password);
            Arrays.fill(pass, ' ');
        }
    }

    public static boolean shouldProvidePassword() {
        if (DSTokenOption.dsTokenWasGiven()) {
            return false;
        }
        if (Hsa2HeadersOption.hsa2headersWereGiven()) {
            return false;
        }
        return !AuthSessionIdOption.sessionIdWasGiven() || !AuthSharedSecretOption.sharedSecretWasGiven();
    }

    public static boolean wasProvided() {
        String password = System.getProperty(NAME);
        return password != null && !password.trim().isEmpty();
    }
}

