/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.Application;
import com.apple.transporter.operation.option.EnumeratedValueOption;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.Validatable;
import org.apache.commons.cli.CommandLine;

public class OutputFormatOption
extends EnumeratedValueOption
implements Validatable {
    public OutputFormatOption() {
        super("outputFormat", new String[]{"xml"}, "The -outputFormat option's only valid value is 'xml'. If this option is not specified then the status information will be displayed textually.");
    }

    @Override
    public void process(CommandLine commandLine) {
        super.process(commandLine);
        if (commandLine.hasOption(this.getOpt())) {
            Application.setGenerateXML(true);
        }
    }

    @Override
    public void validate(CommandLine commandLine) throws OptionValidationException {
        super.validate(commandLine);
        if (commandLine.hasOption(this.getOpt()) && System.getProperty("m").equals("queryTickets")) {
            throw new OptionValidationException("XML output is not supported for queryTickets mode.");
        }
    }
}

