/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.operation.option.AppleIdOption;
import com.apple.transporter.operation.option.AuthSessionIdOption;
import com.apple.transporter.operation.option.AuthSharedSecretOption;
import com.apple.transporter.operation.option.AuthenticationOption;
import com.apple.transporter.operation.option.DSTokenOption;
import com.apple.transporter.operation.option.Hsa2HeadersOption;
import com.apple.transporter.operation.option.ItcProviderNameOption;
import com.apple.transporter.operation.option.MultipleIdOption;
import com.apple.transporter.operation.option.PasswordOption;
import com.apple.transporter.operation.option.ProviderNameOption;
import com.apple.transporter.operation.option.UsernameOption;
import com.apple.transporter.operation.option.VendorIdOption;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class OptionHelper {
    public static void addUsernameAndPasswordAuthenticationOptions(Options options, boolean usernameIsRequired, boolean includeHidden) {
        AuthenticationOption.required(usernameIsRequired);
        options.addOption((Option)new UsernameOption());
        options.addOption((Option)new PasswordOption());
        if (includeHidden) {
            options.addOption((Option)new DSTokenOption());
            options.addOption((Option)new Hsa2HeadersOption());
            options.addOption((Option)new AuthSessionIdOption());
            options.addOption((Option)new AuthSharedSecretOption());
        }
    }

    public static void addAuthenticationOptions(Options options, boolean providerIsRequired, boolean usernameIsRequired, boolean includeHidden) {
        OptionHelper.addUsernameAndPasswordAuthenticationOptions(options, usernameIsRequired, includeHidden);
        if (providerIsRequired) {
            options.addOption((Option)new ProviderNameOption(ProviderNameOption.Variant.Short, providerIsRequired));
        } else {
            options.addOptionGroup(OptionHelper.encodingHouseProviderOrITCUserProviderGroup());
        }
    }

    public static void addAuthenticationOptions(Options options, boolean providerIsRequired, boolean includeHidden) {
        OptionHelper.addAuthenticationOptions(options, providerIsRequired, true, includeHidden);
    }

    private static OptionGroup encodingHouseProviderOrITCUserProviderGroup() {
        OptionGroup group = new OptionGroup();
        group.setRequired(false);
        group.addOption((Option)new ProviderNameOption(ProviderNameOption.Variant.Short, false));
        group.addOption((Option)new ItcProviderNameOption());
        return group;
    }

    public static OptionGroup appleIdOrVendorIdOptionGroup(boolean required, AppleIdOption.Variant appleIdVariant, VendorIdOption.Variant vendorIdVariant) {
        OptionGroup group = new OptionGroup();
        group.setRequired(required);
        group.addOption((Option)new AppleIdOption(appleIdVariant));
        group.addOption((Option)new VendorIdOption(vendorIdVariant));
        return group;
    }

    public static OptionGroup appleIdOrVendorIdOptionGroup(AppleIdOption.Variant appleIdVariant, VendorIdOption.Variant vendorIdVariant) {
        OptionGroup group = OptionHelper.appleIdOrVendorIdOptionGroup(true, appleIdVariant, vendorIdVariant);
        group.addOption((Option)new MultipleIdOption(MultipleIdOption.Variant.AppleIdentifiers));
        group.addOption((Option)new MultipleIdOption(MultipleIdOption.Variant.VendorIdentifiers));
        return group;
    }
}

