/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.Validatable;
import org.apache.commons.cli.CommandLine;

public class NumericOption
extends BaseOption
implements Validatable {
    public NumericOption(String opt) throws IllegalArgumentException {
        super(opt, true);
    }

    public NumericOption(String opt, String description) throws IllegalArgumentException {
        super(opt, true, description);
    }

    @Override
    public void validate(CommandLine commandLine) throws OptionValidationException {
        String value = commandLine.getOptionValue(this.getOpt());
        try {
            Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new OptionValidationException("Please specify a valid value for option: " + this.getOpt());
        }
    }
}

