/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.operation.option.BaseOption;

public class MultipleIdOption
extends BaseOption {
    private static final long serialVersionUID = -2088899379316882567L;

    public MultipleIdOption(Variant variant) {
        super(variant.opt, true, variant.description);
    }

    public static String vendorIdentifiers() {
        return System.getProperty(Variant.VendorIdentifiers.opt);
    }

    public static String appleIdentifiers() {
        return System.getProperty(Variant.AppleIdentifiers.opt);
    }

    public static enum Variant {
        VendorIdentifiers("vendor_ids", "The -vendor_ids option value is used to get the status information for packages uploaded with the given vendor identifiers. You cannot use this option with -vendor_id, -apple_id, or -apple_ids option."),
        AppleIdentifiers("apple_ids", "The -apple_ids option value is used to get the status information for packages uploaded with the given apple identifiers. You cannot use this option with -vendor_id, -apple_id, or -vendor_ids option.");

        final String opt;
        final String description;

        private Variant(String opt, String description) {
            this.opt = opt;
            this.description = description;
        }
    }
}

