/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.ProviderNameOption;
import com.apple.transporter.operation.option.Validatable;
import org.apache.commons.cli.CommandLine;

public class ItcProviderNameOption
extends BaseOption
implements Validatable {
    private static final long serialVersionUID = 7770951305075777014L;
    public static final String NAME = "itc_provider";

    public ItcProviderNameOption() throws IllegalArgumentException {
        super(NAME, true, "The itc_provider option specifies the iTunes Connect provider's short name.");
        this.setMaxArgumentValues(1);
    }

    @Override
    public void validate(CommandLine commandLine) throws OptionValidationException {
        String itcProviderName = ItcProviderNameOption.itcProviderName();
        String ehProviderName = ProviderNameOption.providerName();
        if (itcProviderName != null && itcProviderName.trim().length() != 0 && ehProviderName != null && ehProviderName.trim().length() != 0 && !ProviderNameOption.providerIsRequired()) {
            throw new OptionValidationException("Please specify either a provider name or an iTC provider name, but not both.");
        }
    }

    public static String itcProviderName() {
        return System.getProperty(NAME);
    }

    public static boolean wasItcProviderNameGiven() {
        String shortName = ItcProviderNameOption.itcProviderName();
        return shortName != null && shortName.trim().length() != 0;
    }
}

