/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.option.AuthenticationOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.codec.binary.Base64;
import org.json.simple.JSONValue;

public class Hsa2HeadersOption
extends AuthenticationOption {
    private static final long serialVersionUID = 5464831979075464455L;
    public static final String NAME = "hsa2headers";
    private static final Map<String, String> hsa2headers = new HashMap<String, String>();

    public Hsa2HeadersOption() throws IllegalArgumentException {
        super(NAME, true, "The -hsa2headers option specifies a base64 encoded json Map of headers to use for HSA2.");
        super.setHidden(true);
    }

    public static boolean hsa2headersWereGiven() {
        return !Hsa2HeadersOption.hsa2headers().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> hsa2headers() {
        Map<String, String> map = hsa2headers;
        synchronized (map) {
            return hsa2headers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(CommandLine commandLine) {
        String base64jsonString;
        if (commandLine.hasOption(this.getOpt()) && (base64jsonString = commandLine.getOptionValue(this.getOpt())) != null && !base64jsonString.trim().isEmpty()) {
            Map<String, String> map = hsa2headers;
            synchronized (map) {
                hsa2headers.clear();
                try {
                    byte[] jsonBytes = Base64.decodeBase64((byte[])base64jsonString.getBytes("UTF-8"));
                    String jsonString = new String(jsonBytes, "UTF-8");
                    Object parsed = JSONValue.parseWithException((String)jsonString);
                    if (parsed != null) {
                        if (parsed instanceof Collection && !((Collection)parsed).isEmpty()) {
                            parsed = ((Collection)parsed).iterator().next();
                        }
                        if (parsed instanceof Map) {
                            hsa2headers.putAll((Map)parsed);
                        }
                    }
                }
                catch (Exception parseException) {
                    Logger.error("invalid value for the hsa2headers option");
                }
            }
        }
    }
}

