/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.Validatable;
import com.apple.transporter.util.TransportUtil;
import org.apache.commons.cli.CommandLine;

public class ErrorLogDestinationOption
extends BaseOption
implements Validatable {
    private static final long serialVersionUID = -3121134703727099363L;
    public static final String NAME = "errorLogs";

    public ErrorLogDestinationOption() throws IllegalArgumentException {
        super(NAME, true, "The -errorLogs option specifies the directory where log files for failed uploads should be created.");
    }

    @Override
    public void validate(CommandLine commandLine) throws OptionValidationException {
        String destPath;
        try {
            destPath = Logger.errorLogsPathFromProperty();
        }
        catch (Exception e) {
            throw new OptionValidationException("The specified error logs directory is not valid.");
        }
        boolean isValidDir = TransportUtil.validateDirectoryPath(destPath, true);
        if (!isValidDir) {
            throw new OptionValidationException("The specified error logs directory is not valid.");
        }
        Logger.setErrorLogsPath(destPath);
    }
}

