/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.Validatable;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;

public class EnumeratedValueOption
extends BaseOption
implements Validatable {
    protected String[] enumeratedValues;

    public EnumeratedValueOption(String opt, String[] enumeratedValues) throws IllegalArgumentException {
        super(opt, true);
        if (enumeratedValues == null) {
            throw new NullPointerException("enumeratedValue cannot be null");
        }
        this.enumeratedValues = enumeratedValues;
    }

    public EnumeratedValueOption(String opt, String[] enumeratedValues, String description) throws IllegalArgumentException {
        super(opt, true, description);
        if (enumeratedValues == null) {
            throw new NullPointerException("enumeratedValue cannot be null");
        }
        this.enumeratedValues = enumeratedValues;
    }

    public String[] getEnumeratedValues() {
        return this.enumeratedValues;
    }

    public String getEnumeratedValuesAsString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : this.enumeratedValues) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public boolean isValueValid(CommandLine line) {
        String value = line.getOptionValue(this.getOpt());
        for (String enumeratedValue : this.enumeratedValues) {
            if ((value != null || enumeratedValue != null) && (value == null || !value.equalsIgnoreCase(enumeratedValue))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void validate(CommandLine commandLine) throws OptionValidationException {
        if (!this.isValueValid(commandLine)) {
            throw new OptionValidationException("Please specify a valid value for option " + this.getOpt() + ": " + Arrays.toString(this.getEnumeratedValues()));
        }
    }
}

