/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.Validatable;
import com.apple.transporter.util.TransportUtil;
import org.apache.commons.cli.CommandLine;

public class DestinationOption
extends BaseOption
implements Validatable {
    public static final String NAME = "destination";
    protected Variant variant;

    public DestinationOption(Variant variant) {
        super(NAME, true, variant.description);
        this.setRequired(variant.required);
        this.variant = variant;
    }

    @Override
    public void validate(CommandLine commandLine) throws OptionValidationException {
        String destPath;
        try {
            destPath = TransportUtil.destinationPathFromProperty();
        }
        catch (Exception e) {
            throw new OptionValidationException("The specified destination directory is not valid.");
        }
        boolean isValidDir = TransportUtil.validateDirectoryPath(destPath, true);
        if (!isValidDir) {
            throw new OptionValidationException("The specified destination directory is not valid.");
        }
    }

    public static enum Variant {
        CreateAssetOnlyStubPackage(true, "The -destination option specifies the directory where the stub package should be created."),
        LookupMetadata(true, "The -destination option specifies the directory where the metadata should be placed."),
        DownloadMetadataGuides(true, "The -destination option specifies the directory where the metadata guides should be placed."),
        RepairEpubAssets(true, "The -destination option specifies the directory where the repaired publication asset should be placed."),
        Generic(true, "The -destination option specifies the directory where the results should be placed.");

        boolean required;
        String description;

        private Variant(boolean required, String description) {
            this.required = required;
            this.description = description;
        }
    }
}

