/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.Validatable;
import org.apache.commons.cli.CommandLine;

public class ConnectionServicePortOption
extends BaseOption
implements Validatable {
    private static final long serialVersionUID = 2676437784231023736L;
    public static final String NAME = "CSPort";

    public ConnectionServicePortOption() throws IllegalArgumentException {
        super(NAME, true, "The -CSPort option specifies the port that the Connection Service will run on. A port of 0 will choose the next available port.");
        this.setHidden(true);
    }

    @Override
    public boolean shouldValidateMissingOption(CommandLine commandLine) {
        return true;
    }

    @Override
    public void validate(CommandLine commandLine) throws OptionValidationException {
        String value = commandLine.getOptionValue(this.getOpt());
        if (null == value) {
            return;
        }
        try {
            int port = Integer.parseInt(value);
            if (port < 0 || port > Short.MAX_VALUE) {
                throw new OptionValidationException("Please specify a valid value for option: " + this.getOpt());
            }
        }
        catch (NumberFormatException e) {
            throw new OptionValidationException("Please specify a valid value for option: " + this.getOpt());
        }
    }

    @Override
    public void process(CommandLine commandLine) {
        super.process(commandLine);
        try {
            this.validate(commandLine);
        }
        catch (OptionValidationException ovx) {
            throw new IllegalArgumentException(ovx.getMessage());
        }
    }
}

