/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.Validatable;
import org.apache.commons.cli.CommandLine;

public class ConnectionServicePoolSizeOption
extends BaseOption
implements Validatable {
    private static final long serialVersionUID = 2676437784231023736L;
    public static final String NAME = "CSPoolSize";

    public ConnectionServicePoolSizeOption() throws IllegalArgumentException {
        super(NAME, true, "The -CSPoolSize option specifies the number of threads available to the Connection Service. If not specified, it will default to 1.  The maximum value is 5.");
        this.setHidden(true);
    }

    @Override
    public boolean shouldValidateMissingOption(CommandLine commandLine) {
        return true;
    }

    @Override
    public void validate(CommandLine commandLine) throws OptionValidationException {
        String value = commandLine.getOptionValue(this.getOpt());
        if (null == value) {
            return;
        }
        try {
            int poolSize = Integer.parseInt(value);
            if (poolSize < 1 || poolSize > 5) {
                throw new OptionValidationException("Please specify a valid value (1-5) for option: " + this.getOpt());
            }
        }
        catch (NumberFormatException e) {
            throw new OptionValidationException("Please specify a valid value for option: " + this.getOpt());
        }
    }

    @Override
    public void process(CommandLine commandLine) {
        super.process(commandLine);
        try {
            this.validate(commandLine);
        }
        catch (OptionValidationException ovx) {
            throw new IllegalArgumentException(ovx.getMessage());
        }
    }
}

