/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.Application;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.option.TrueFalseOption;
import org.apache.commons.cli.CommandLine;

public class ChecksumValidationOption
extends TrueFalseOption {
    public ChecksumValidationOption() {
        super("checksumValidation");
    }

    @Override
    public void process(CommandLine commandLine) {
        super.process(commandLine);
        String checksumValidation = commandLine.getOptionValue(this.getOpt());
        String transporterClientVersion = System.getProperty("transporter.client.version");
        String transporterClient = System.getProperty("transporter.client");
        boolean shouldPerformChecksum = true;
        if (checksumValidation != null && checksumValidation.trim().equalsIgnoreCase("false") && transporterClientVersion != null && transporterClient != null) {
            Logger.info("MD5 checksum calculation in the transporter will be skipped.");
            shouldPerformChecksum = false;
        } else if (checksumValidation != null && !checksumValidation.trim().equalsIgnoreCase("false") && !checksumValidation.trim().equalsIgnoreCase("true")) {
            Logger.error("Invalid option specified for checksum validation flag. MD5 checksums will be calculated.");
            shouldPerformChecksum = true;
        } else if (checksumValidation != null) {
            Logger.info("MD5 checksum calculation in the transporter can NOT be skipped.");
            shouldPerformChecksum = true;
        }
        Application.setShouldPerformChecksum(shouldPerformChecksum);
    }
}

