/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.io.FileUtils;

public class BaseOption
extends Option {
    private static final long serialVersionUID = -1332926915516028115L;
    protected boolean isHidden = false;

    public BaseOption(String opt, boolean hasArg) throws IllegalArgumentException {
        this(opt, hasArg, "", false);
    }

    public BaseOption(String opt, boolean hasArg, boolean hidden) throws IllegalArgumentException {
        this(opt, hasArg, "", hidden);
    }

    public BaseOption(String opt, boolean hasArg, String description) throws IllegalArgumentException {
        this(opt, hasArg, description, false);
    }

    public BaseOption(String opt, boolean hasArg, String description, boolean hidden) throws IllegalArgumentException {
        super(opt, hasArg, description);
        this.isHidden = hidden;
    }

    public void process(CommandLine commandLine) {
        if (commandLine.hasOption(this.getOpt()) && (this.hasArg() || this.hasOptionalArg())) {
            String[] values;
            String value = commandLine.getOptionValue(this.getOpt());
            int maxArgCount = this.getArgs();
            if (maxArgCount != -1 && maxArgCount != -2 && (values = commandLine.getOptionValues(this.getOpt())).length > maxArgCount) {
                if (maxArgCount == 1) {
                    throw new IllegalArgumentException("The option: \"-" + this.getOpt() + "\" may only be specified once.");
                }
                throw new IllegalArgumentException("The option: \"-" + this.getOpt() + "\" may only be specified up to " + String.valueOf(maxArgCount) + " times.");
            }
            if (value != null) {
                if (value.toLowerCase().startsWith("@env:")) {
                    String envName = value.substring(5);
                    if ((value = System.getenv(envName)) == null) {
                        throw new IllegalArgumentException("@env: parameter is null: " + envName);
                    }
                } else if (value.toLowerCase().startsWith("@file:")) {
                    try {
                        String filePath = value.substring(6);
                        File file = new File(FileUtil.absolutePathForPath(filePath));
                        if (!file.exists() || !file.isFile()) {
                            throw new IllegalArgumentException("@file: parameter points to non-existant file: " + filePath);
                        }
                        value = new String(FileUtils.readFileToByteArray((File)file)).trim();
                        if (value.length() == 0) {
                            throw new IllegalArgumentException("@file: parameter is null or empty: " + filePath);
                        }
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("@file: parameter generated an error", e);
                    }
                }
            }
            if (this.hasArg() || this.hasOptionalArg() && value != null) {
                System.setProperty(this.getOpt(), value);
            }
        }
    }

    public boolean shouldValidateMissingOption(CommandLine commandLine) {
        return false;
    }

    public BaseOption setRequiredFluently(boolean required) {
        this.setRequired(required);
        return this;
    }

    public BaseOption setMaxArgumentValues(int maxArgumentValues) {
        this.setArgs(maxArgumentValues);
        return this;
    }

    public BaseOption setHidden(boolean hidden) {
        this.isHidden = hidden;
        return this;
    }

    public boolean isHidden() {
        return this.isHidden;
    }
}

