/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.operation.option.AuthSessionIdOption;
import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.Validatable;
import org.apache.commons.cli.CommandLine;

public class AuthSharedSecretOption
extends BaseOption
implements Validatable {
    private static final long serialVersionUID = 6438401673049916213L;
    public static final String NAME = "sharedsecret";

    public AuthSharedSecretOption() {
        super(NAME, true, "The -sharedsecret option specifies your shared secret for session based authentication.");
        this.setOptionalArg(true);
    }

    public static boolean sharedSecretWasGiven() {
        String sharedSecret = AuthSharedSecretOption.sharedSecret();
        return null != sharedSecret && sharedSecret.trim().length() > 0;
    }

    public static String sharedSecret() {
        String sharedsecret = System.getProperty(NAME);
        return sharedsecret;
    }

    @Override
    public void validate(CommandLine commandLine) throws OptionValidationException {
        if (AuthSharedSecretOption.sharedSecretWasGiven() && !AuthSessionIdOption.sessionIdWasGiven()) {
            throw new OptionValidationException("The shared secret option must also have the sessionid specified.");
        }
    }
}

