/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.operation.option.AuthSharedSecretOption;
import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.Validatable;
import org.apache.commons.cli.CommandLine;

public class AuthSessionIdOption
extends BaseOption
implements Validatable {
    private static final long serialVersionUID = -6801184866062674919L;
    public static final String NAME = "sessionid";

    public AuthSessionIdOption() {
        super(NAME, true, "The -sessionid option specifies your session id for session based authentication.");
        this.setOptionalArg(true);
    }

    public static boolean sessionIdWasGiven() {
        String sessionId = AuthSessionIdOption.sessionId();
        return null != sessionId && sessionId.trim().length() > 0;
    }

    public static String sessionId() {
        String sessionId = System.getProperty(NAME);
        return sessionId;
    }

    @Override
    public void validate(CommandLine commandLine) throws OptionValidationException {
        if (AuthSessionIdOption.sessionIdWasGiven() && !AuthSharedSecretOption.sharedSecretWasGiven()) {
            throw new OptionValidationException("The session id option must also have the shared secret specified.");
        }
    }
}

