/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.Validatable;
import com.apple.transporter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;

public class AssetFolderOption
extends BaseOption
implements Validatable {
    public static final String NAME = "assetFolder";

    public AssetFolderOption(Variant variant) {
        super(NAME, true, variant.description);
        this.setRequired(true);
    }

    @Override
    public void validate(CommandLine commandLine) throws OptionValidationException {
        try {
            String path = FileUtil.absolutePathForPath(commandLine.getOptionValue(this.getOpt()));
            File file = new File(path);
            if (!file.isDirectory()) {
                throw new OptionValidationException("The '-assetFolder' option must specify an existing folder.");
            }
        }
        catch (IOException ioe) {
            throw new OptionValidationException("Please specify a valid value for the '-assetFolder' option.");
        }
    }

    public static enum Variant {
        Generic("The -assetFolder option specifies the directory where the source assets are located."),
        GeneratePublicationPackage("The -assetFolder option specifies the directory where the source assets (publications, cover art, etc.) are located."),
        RepairEpubAssets("The -assetFolder option specifies a directory where publication asset files are located.");

        String description;

        private Variant(String description) {
            this.description = description;
        }
    }
}

