/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.Validatable;
import com.apple.transporter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;

public class AssetFileOption
extends BaseOption
implements Validatable {
    public static final String NAME = "assetFile";

    public AssetFileOption(Variant variant) throws IllegalArgumentException {
        super(NAME, true, variant.description);
    }

    @Override
    public void validate(CommandLine commandLine) throws OptionValidationException {
        try {
            String path = FileUtil.absolutePathForPath(commandLine.getOptionValue(this.getOpt()));
            File file = new File(path);
            if (!file.exists() || !file.isFile()) {
                throw new OptionValidationException("The '-assetFile' option must specify an existing file.");
            }
        }
        catch (IOException ioe) {
            throw new OptionValidationException("Please specify a valid value for the '-assetFile' option.");
        }
    }

    public static enum Variant {
        Generic("The -assetFile option specifies a single source asset file."),
        RepairEpubAssets("The -assetFile option specifies a single source publication asset file to be repaired.");

        String description;

        private Variant(String description) {
            this.description = description;
        }
    }
}

