/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.operation.option.NumericOption;

public class AppleIdOption
extends NumericOption {
    private static final long serialVersionUID = 3653136541574286744L;

    public AppleIdOption(Variant variant) {
        super("apple_id", variant.description);
    }

    public static String appleIdentifier() {
        return System.getProperty("apple_id");
    }

    public static enum Variant {
        Generic("The -apple_id option value specifies the Apple identifier to use."),
        LookupMetadata("The -apple_id option value specifies the Apple identifier used when generating the metadata XML for the content known by Apple.  You cannot use this option with -vendor_id, -vendor_ids, or -apple_ids option."),
        QueryTickets("The -apple_id option value specifies the apple identifier used when generating the tickets XML for the content known by Apple.  You cannot use this option with -vendor_id, -vendor_ids, or -apple_ids option."),
        Status("The -apple_id option value is used to get the status information for the content known by Apple. You cannot use this option with -vendor_id, -vendor_ids, or -apple_ids option."),
        QCDownload("The -apple_id option value is used to specify the QC to download.");

        String description;

        private Variant(String description) {
            this.description = description;
        }
    }
}

