/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

import com.apple.transporter.operation.option.AppPlatform;
import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.Validatable;
import org.apache.commons.cli.CommandLine;

public class AppPlatformOption
extends BaseOption
implements Validatable {
    private static final long serialVersionUID = -3053112695969461363L;
    private static final String ARGUMENT_DICT__APP_PLATFORM_KEY = "app_platform";

    public AppPlatformOption() {
        super(ARGUMENT_DICT__APP_PLATFORM_KEY, true, "The -app_platform option values are 'ios', 'macos', 'appletvos', and 'appletvtemplate'.");
    }

    @Override
    public void validate(CommandLine commandLine) throws OptionValidationException {
        if (!commandLine.hasOption(this.getOpt())) {
            return;
        }
        String value = commandLine.getOptionValue(this.getOpt());
        AppPlatform platform = AppPlatform.forStringValue(value);
        if (null == platform) {
            throw new OptionValidationException("The value of " + value + " is not valid for " + this.getOpt() + ".");
        }
    }

    public static String appPlatform() {
        String value = System.getProperty(ARGUMENT_DICT__APP_PLATFORM_KEY);
        AppPlatform platform = AppPlatform.forStringValue(value);
        if (null == platform) {
            return null;
        }
        return platform.webServiceValue;
    }

    public static boolean hasAppPlatform() {
        String appPlatform = AppPlatformOption.appPlatform();
        return appPlatform != null && appPlatform.length() > 0;
    }
}

