/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.option;

public enum AppPlatform {
    AppleTVOS("tvOS", "appletvos", new String[]{"appletvos", "tvos"}),
    AppleTVTemplate("Apple TV Template", "appletvtemplate", new String[]{"appletvtemplate"}),
    IOS("iOS", "ios", new String[]{"ios", "watchos"}),
    MacOS("macOS", "osx", new String[]{"macos", "osx"});

    public final String displayValue;
    public final String webServiceValue;
    public final String[] optionalValues;

    private AppPlatform(String displayValue, String webServiceValue, String[] optionalValues) {
        this.displayValue = displayValue;
        this.webServiceValue = webServiceValue;
        this.optionalValues = optionalValues;
    }

    public static AppPlatform forStringValue(String value) {
        for (AppPlatform plat : AppPlatform.values()) {
            for (String option : plat.optionalValues) {
                if (!option.equalsIgnoreCase(value)) continue;
                return plat;
            }
        }
        return null;
    }
}

