/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.lookupmetadata;

import com.apple.transporter.Application;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.lookupmetadata.FetchMetadataByAppleId;
import com.apple.transporter.operation.lookupmetadata.FetchMetadataByMultipleAppleId;
import com.apple.transporter.operation.lookupmetadata.FetchMetadataByMultipleVendorId;
import com.apple.transporter.operation.lookupmetadata.FetchMetadataByVendorId;
import com.apple.transporter.operation.option.AppleIdOption;
import com.apple.transporter.operation.option.MultipleIdOption;
import com.apple.transporter.operation.option.VendorIdOption;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.StreamUtil;
import com.apple.transporter.util.StringUtil;
import com.apple.transporter.util.TransportUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

public abstract class MetadataFetcher {
    private final String logSuffix;
    final WebService service;
    private final String destDirPath;

    public abstract boolean fetchMetadata();

    MetadataFetcher(String logMessage, WebService service) {
        String destDirPath;
        this.logSuffix = logMessage;
        this.service = service;
        try {
            destDirPath = TransportUtil.destinationPathFromProperty();
        }
        catch (Throwable t) {
            Logger.error("The specified destination path is not valid.", t);
            destDirPath = null;
        }
        this.destDirPath = destDirPath;
    }

    public static MetadataFetcher createFetcher(WebService service) {
        String vendorIds = MultipleIdOption.vendorIdentifiers();
        String appleIds = MultipleIdOption.appleIdentifiers();
        String vendorId = VendorIdOption.vendorIdentifier();
        String appleId = AppleIdOption.appleIdentifier();
        if (vendorIds != null && vendorIds.trim().length() != 0) {
            return new FetchMetadataByMultipleVendorId("vendor_ids '" + vendorIds, service, vendorIds);
        }
        if (appleIds != null && appleIds.trim().length() != 0) {
            return new FetchMetadataByMultipleAppleId("apple_ids '" + appleIds, service, appleIds);
        }
        if (vendorId != null && vendorId.trim().length() != 0) {
            return new FetchMetadataByVendorId("vendor_id '" + vendorId, service, vendorId);
        }
        if (appleId != null && appleId.trim().length() != 0) {
            return new FetchMetadataByAppleId("apple_id '" + appleId, service, appleId);
        }
        throw new IllegalArgumentException("Please specify an appropriate identifier for lookupMetadata mode.");
    }

    boolean fetchMetadataForVendorId(final String vendorId) {
        try {
            Logger.info("Looking up the metadata with the " + this.logSuffix + "' ...");
            Map returnValue = (Map)WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, ?>>(){

                @Override
                public void setNetworkIsReachable(boolean isReachable) {
                }

                @Override
                public Map<String, ?> invoke() {
                    return MetadataFetcher.this.service.lookupMetadataForVendorIdOperation(vendorId);
                }
            });
            return this.handleMetadataLookupResponse(vendorId, returnValue);
        }
        catch (Throwable t) {
            Logger.error("Error occurred while looking up the metadata with " + this.logSuffix + "'.", t);
            return false;
        }
    }

    boolean fetchMetadataForAppleId(final String appleId) {
        try {
            Logger.info("Looking up the metadata with the " + this.logSuffix + "' ...");
            Map returnValue = (Map)WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, ?>>(){

                @Override
                public void setNetworkIsReachable(boolean isReachable) {
                }

                @Override
                public Map<String, ?> invoke() {
                    return MetadataFetcher.this.service.lookupMetadataForAppleIdOperation(appleId);
                }
            });
            return this.handleMetadataLookupResponse(appleId, returnValue);
        }
        catch (Throwable t) {
            Logger.error("Error occurred while looking up the metadata with " + this.logSuffix + "'.", t);
            return false;
        }
    }

    boolean checkServerResponse(Map<String, ?> returnValue) {
        if (returnValue == null) {
            Application.logUnnecessaryError("Unable to retrieve the metadata.");
            return false;
        }
        if (Application.doesContainSOAPError(returnValue)) {
            Application.logUnnecessaryError("An error occurred while looking up the metadata.");
            Application.displaySOAPErrorMessages(returnValue);
            return false;
        }
        return true;
    }

    private boolean handleMetadataLookupResponse(String identifier, Map<String, ?> returnValue) throws IOException, NoSuchAlgorithmException, UnsupportedEncodingException {
        if (!this.checkServerResponse(returnValue)) {
            return false;
        }
        String xml = (String)returnValue.get(System.getProperty("generatedMetadataKey"));
        if (xml == null || xml.trim().length() == 0) {
            String checksumKey = System.getProperty("checksummedBlobChecksumKey");
            String gzipContentKey = System.getProperty("checksummedBlobGzipContentKey");
            Map checksummedBlob = (Map)returnValue.get(System.getProperty("generatedMetadataCompressedKey"));
            if (checksummedBlob == null || !checksummedBlob.containsKey(checksumKey) || !checksummedBlob.containsKey(gzipContentKey) || ((String)checksummedBlob.get(gzipContentKey)).trim().length() == 0) {
                Logger.error("No metadata xml was returned by Apple's web service operation.");
                return false;
            }
            xml = StreamUtil.base64GzipToString((String)checksummedBlob.get(gzipContentKey));
            byte[] hash = FileUtil.md5(new ByteArrayInputStream(xml.getBytes("UTF-8")));
            String checksum = StringUtil.byteArrayToHexString(hash);
            if (!checksum.equalsIgnoreCase((String)checksummedBlob.get(checksumKey))) {
                Logger.error("Checksum of metadata xml returned by Apple's web service operation does not match expected checksum.");
                return false;
            }
        }
        try {
            boolean didCreateStubPkg = TransportUtil.createStubPackageForMetadata(xml, identifier, this.destDirPath);
            if (!didCreateStubPkg) {
                return false;
            }
        }
        catch (IOException ioe) {
            Logger.error("An error occurred while creating the stub package for the generated metadata.", ioe);
        }
        Logger.essential("\n\nLooking up the metadata and creating a stub package for it is done.");
        return true;
    }
}

