/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.lookupmetadata;

import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.lookupmetadata.MetadataFetcher;
import java.util.Map;

public class FetchMetadataByMultipleVendorId
extends MetadataFetcher {
    private final String vendorIds;

    FetchMetadataByMultipleVendorId(String logMessage, WebService service, String vendorIds) {
        super(logMessage, service);
        this.vendorIds = vendorIds;
    }

    @Override
    public boolean fetchMetadata() {
        Map<String, Object> returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, Object>>(){

            @Override
            public void setNetworkIsReachable(boolean isReachable) {
            }

            @Override
            public Map<String, Object> invoke() {
                return FetchMetadataByMultipleVendorId.this.service.lookupMetadataVendorIds(FetchMetadataByMultipleVendorId.this.vendorIds);
            }
        });
        if (!this.checkServerResponse(returnValue)) {
            return false;
        }
        Object[] parsedVendorIds = (Object[])returnValue.get(System.getProperty("VendorIdsKey"));
        if (parsedVendorIds == null) {
            Logger.error("Unable to retrieve the metadata.");
            return false;
        }
        boolean response = true;
        for (Object parsedVendorId : parsedVendorIds) {
            boolean singleResponse = this.fetchMetadataForVendorId(parsedVendorId.toString());
            response = response && singleResponse;
        }
        return response;
    }
}

