/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.lookupmetadata;

import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.lookupmetadata.MetadataFetcher;
import java.util.Map;

public class FetchMetadataByMultipleAppleId
extends MetadataFetcher {
    private final String appleIds;

    public FetchMetadataByMultipleAppleId(String logMessage, WebService service, String appleIds) {
        super(logMessage, service);
        this.appleIds = appleIds;
    }

    @Override
    public boolean fetchMetadata() {
        Map<String, Object> returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, Object>>(){

            @Override
            public void setNetworkIsReachable(boolean isReachable) {
            }

            @Override
            public Map<String, Object> invoke() {
                return FetchMetadataByMultipleAppleId.this.service.lookupMetadataAppleIds(FetchMetadataByMultipleAppleId.this.appleIds);
            }
        });
        if (!this.checkServerResponse(returnValue)) {
            return false;
        }
        Object[] parsedAppleIds = (Object[])returnValue.get(System.getProperty("AppleIdsKey"));
        if (parsedAppleIds == null) {
            Logger.error("Unable to retrieve the metadata.");
            return false;
        }
        boolean response = true;
        for (Object parsedAppleId : parsedAppleIds) {
            boolean singleResponse = this.fetchMetadataForAppleId(parsedAppleId.toString());
            response = response && singleResponse;
        }
        return response;
    }
}

