/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.ehusercrud;

import com.apple.transporter.Application;
import com.apple.transporter.ErrorMessageCollector;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.DSTokenOption;
import com.apple.transporter.operation.option.Hsa2HeadersOption;
import com.apple.transporter.operation.option.PasswordOption;
import com.apple.transporter.operation.option.TrueFalseOption;
import com.apple.transporter.operation.option.UsernameOption;
import com.apple.transporter.util.StreamUtil;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class EncodingHouseUserList
extends Operation {
    public static final String MODE_VALUE = "encodingHouseUserList";

    public EncodingHouseUserList(WebService service) {
        super(service);
    }

    @Override
    public boolean execute() {
        ErrorMessageCollector.sharedInstance().setupToCollectErrorMessagesForNonPackageBasedModes();
        Map results = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map>(){

            @Override
            public void setNetworkIsReachable(boolean isReachable) {
            }

            @Override
            public Map invoke() {
                return EncodingHouseUserList.this.service.listEncodingHouseUsers(Boolean.getBoolean("includeInactive"));
            }
        });
        boolean success = true;
        if (results != null) {
            if (Application.doesContainSOAPError(results)) {
                Application.displaySOAPErrorMessages(results);
                success = false;
            } else {
                try {
                    String base64Tickets = (String)results.get(System.getProperty("encodingHouseUsersKey"));
                    if (base64Tickets != null) {
                        String s = StreamUtil.base64GzipToString(base64Tickets);
                        Application.writeXML(s);
                    }
                }
                catch (IOException e) {
                    Logger.error("Failure extracting encoding house user list results", e);
                    success = false;
                }
            }
        } else {
            success = false;
        }
        if (!success) {
            Application.showNonPackageBasedErrorSummary();
        }
        return success;
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        options.addOption((Option)new UsernameOption());
        options.addOption((Option)new PasswordOption());
        if (includeHidden) {
            options.addOption((Option)new DSTokenOption());
            options.addOption((Option)new Hsa2HeadersOption());
        }
        TrueFalseOption includeInactiveOption = new TrueFalseOption("includeInactive", "If true the list of encoding house users will include inactive users as well as active users.");
        options.addOption((Option)includeInactiveOption);
        return options;
    }
}

