/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation.ehusercrud;

import com.apple.transporter.Application;
import com.apple.transporter.ErrorMessageCollector;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.DSTokenOption;
import com.apple.transporter.operation.option.Hsa2HeadersOption;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.PasswordOption;
import com.apple.transporter.operation.option.UsernameOption;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class EncodingHouseUserAdd
extends Operation {
    public static final String MODE_VALUE = "encodingHouseUserAdd";

    public EncodingHouseUserAdd(WebService service) {
        super(service);
    }

    @Override
    public boolean execute() {
        ErrorMessageCollector.sharedInstance().setupToCollectErrorMessagesForNonPackageBasedModes();
        Map results = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map>(){

            @Override
            public void setNetworkIsReachable(boolean isReachable) {
            }

            @Override
            public Map invoke() {
                return EncodingHouseUserAdd.this.service.createEncodingHouseUserAddRequest();
            }
        });
        boolean success = true;
        if (results != null) {
            if (Application.doesContainSOAPError(results)) {
                Application.displaySOAPErrorMessages(results);
                success = false;
            }
        } else {
            success = false;
        }
        if (!success) {
            Application.showNonPackageBasedErrorSummary();
        } else {
            Logger.essential("\n\nNew encoding house user request was successful.");
        }
        return success;
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        OptionGroup group = new OptionGroup();
        group.setRequired(true);
        UsernameOption usernameOption = new UsernameOption(){

            @Override
            public void validate(CommandLine commandLine) throws OptionValidationException {
                if (System.getProperty("p") == null) {
                    throw new OptionValidationException("-p must be provided when specifying -u");
                }
            }
        };
        usernameOption.setRequired(false);
        group.addOption((Option)usernameOption);
        PasswordOption passwordOption = new PasswordOption();
        passwordOption.setRequired(false);
        options.addOption((Option)passwordOption);
        if (includeHidden) {
            options.addOption((Option)new DSTokenOption());
            options.addOption((Option)new Hsa2HeadersOption());
        }
        BaseOption encodingHouseOption = new BaseOption("encodingHouse", true, "The encoding house to which the new user will be added.");
        encodingHouseOption.setRequired(false);
        group.addOption((Option)encodingHouseOption);
        options.addOptionGroup(group);
        BaseOption emailOption = new BaseOption("email", true, "The email address of the user to add.");
        emailOption.setRequired(true);
        options.addOption((Option)emailOption);
        return options;
    }
}

