/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.ErrorMessageCollector;
import com.apple.transporter.ServerConnectionException;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.log.TransportLog;
import com.apple.transporter.model.AssetValidationUpload;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.OptionHelper;
import com.apple.transporter.operation.option.PackageSourceFolderOption;
import com.apple.transporter.operation.option.UsernameOption;
import com.apple.transporter.transport.TransportReturnValue;
import com.apple.transporter.transport.TransportType;
import com.apple.transporter.transport.WebDAVTransport;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.NSPathUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class VerifyAssetOperation
extends Operation {
    public static final String MODE_VALUE = "verifyAsset";
    private static final String RETURN_DICT__NEW_FILENAME_KEY = "NewPackageName";
    private static final String RETURN_DICT__WEBDAVSERVERNAME_KEY = "WebDavServerName";
    private static final String RETURN_DICT__WEBDAVFOLDERPATH_KEY = "WebDavFolderPath";
    private static final String RETURN_DICT__ATTRIBUTES_KEY = "Attributes";
    private static final String RETURN_DICT__DISPLAY_KEYS_KEY = "DisplayKeys";

    public VerifyAssetOperation(WebService service) {
        super(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        try {
            ErrorMessageCollector.sharedInstance().setupToCollectErrorMessagesForNonPackageBasedModes();
            Logger.startCachingLogMessages();
            Logger.info("Performing asset verification request ...");
            AssetValidationUpload upload = this.createAssetValidationUpload();
            TransportType transportType = TransportType.DAV;
            if (!this.authenticateAssetVerification(upload, transportType)) {
                Application.showNonPackageBasedErrorSummary();
                boolean bl = false;
                return bl;
            }
            if (!this.uploadSnowfallAsset(upload)) {
                this.reportUploadFailure(upload, transportType);
                Application.showNonPackageBasedErrorSummary();
                boolean bl = false;
                return bl;
            }
            if (!this.performServerSideVerification(upload, transportType)) {
                this.reportUploadFailure(upload, transportType);
                Application.showNonPackageBasedErrorSummary();
                boolean bl = false;
                return bl;
            }
        }
        catch (FileNotFoundException fnfe) {
            Logger.error("An error occurred while verifying an asset.  The file " + fnfe.getMessage() + " was not found.");
            Application.showNonPackageBasedErrorSummary();
            boolean bl = false;
            return bl;
        }
        catch (NoSuchAlgorithmException nsae) {
            Logger.error("An error occurred while verifying an asset.  The MD5 algorithm was not found.", nsae);
            Application.showNonPackageBasedErrorSummary();
            boolean bl = false;
            return bl;
        }
        catch (Throwable t) {
            Logger.error("An error occurred while verifying an asset.", t);
            Application.showNonPackageBasedErrorSummary();
            boolean bl = false;
            return bl;
        }
        finally {
            Logger.stopCachingLogMessages();
            Logger.clearLogCache();
        }
        return true;
    }

    private void reportUploadFailure(final AssetValidationUpload upload, final TransportType transportType) {
        try {
            Map<String, ? extends Object> returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, ? extends Object>>(){

                @Override
                public void setNetworkIsReachable(boolean isReachable) {
                }

                @Override
                public Map<String, ? extends Object> invoke() {
                    TransportLog transportLog = Logger.logCache();
                    return VerifyAssetOperation.this.service.snowfallUploadFailed(upload, transportLog, transportType);
                }
            });
            if (returnValue == null) {
                Application.logUnnecessaryError("Unable to report asset verification failure.");
                return;
            }
            if (Application.doesContainSOAPError(returnValue)) {
                Application.logUnnecessaryError("An error occurred during reporting asset verification failure.");
                Application.displaySOAPErrorMessages(returnValue);
                return;
            }
        }
        catch (Throwable t) {
            Logger.error("An error occurred while reporting upload failure.", t);
        }
    }

    private boolean authenticateAssetVerification(final AssetValidationUpload upload, final TransportType transportType) {
        Map<String, ? extends Object> returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, ? extends Object>>(){

            @Override
            public void setNetworkIsReachable(boolean isReachable) {
            }

            @Override
            public Map<String, ? extends Object> invoke() {
                return VerifyAssetOperation.this.service.snowfallAuthenticate(upload, transportType);
            }
        });
        if (returnValue == null) {
            Application.logUnnecessaryError("Unable to verify asset.");
            return false;
        }
        if (Application.doesContainSOAPError(returnValue)) {
            Application.logUnnecessaryError("An error occurred during asset verification.");
            Application.displaySOAPErrorMessages(returnValue);
            return false;
        }
        return this.extractAssetValidationUploadAttributesFromAuthenticateResults(returnValue, upload);
    }

    private boolean extractAssetValidationUploadAttributesFromAuthenticateResults(Map<String, ? extends Object> returnValue, AssetValidationUpload upload) {
        String newFilename = (String)returnValue.get(RETURN_DICT__NEW_FILENAME_KEY);
        String webDAVServerName = (String)returnValue.get(RETURN_DICT__WEBDAVSERVERNAME_KEY);
        String webDAVFolderPath = (String)returnValue.get(RETURN_DICT__WEBDAVFOLDERPATH_KEY);
        upload.setNewFilename(newFilename);
        upload.setWebDAVServerName(webDAVServerName);
        upload.setWebDAVFolderPath(webDAVFolderPath);
        if (newFilename == null || webDAVServerName == null || webDAVFolderPath == null) {
            Logger.error("Missing expected results from authentication operation.");
            return false;
        }
        return true;
    }

    private boolean uploadSnowfallAsset(AssetValidationUpload upload) {
        WebDAVTransport transport = new WebDAVTransport();
        transport.setNewPackageName(upload.getNewFilename());
        transport.setFolderPath(upload.getWebDAVFolderPath());
        transport.setUsername(UsernameOption.username());
        transport.setPassword(System.getProperty("p"));
        transport.setServerNames(Arrays.asList(upload.getWebDAVServerName()));
        String fullPath = upload.getPath();
        TransportReturnValue result = null;
        try {
            result = transport.uploadFile(fullPath, this.service);
        }
        catch (ServerConnectionException e) {
            Logger.error("Unable to connect to the WebDAV server.", e);
            return false;
        }
        catch (Exception e) {
            Logger.error("Unable to deliver the asset to Apple.", e);
            return false;
        }
        return result.wasTransferSuccessful();
    }

    private boolean performServerSideVerification(final AssetValidationUpload upload, final TransportType transportType) {
        Map<String, ? extends Object> returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, ? extends Object>>(){

            @Override
            public void setNetworkIsReachable(boolean isReachable) {
            }

            @Override
            public Map<String, ? extends Object> invoke() {
                return VerifyAssetOperation.this.service.snowfallValidateAssets(upload, transportType);
            }
        });
        if (returnValue == null) {
            Application.logUnnecessaryError("Unable to verify asset.");
            return false;
        }
        if (Application.doesContainSOAPError(returnValue)) {
            Application.displaySOAPErrorMessages(returnValue);
            return false;
        }
        return this.displayReturnValue(returnValue, Application.XMLStream);
    }

    private String getUploadPath() throws IOException {
        String filePath = System.getProperty("f");
        filePath = FileUtil.absolutePathForPath(filePath);
        return filePath;
    }

    private String getUploadFilename() throws IOException {
        String filePath = this.getUploadPath();
        String filename = NSPathUtilities.lastPathComponent(filePath);
        return filename;
    }

    private AssetValidationUpload createAssetValidationUpload() throws IOException, NoSuchAlgorithmException {
        AssetValidationUpload upload = new AssetValidationUpload();
        String filePath = this.getUploadPath();
        upload.setPath(filePath);
        String filename = NSPathUtilities.lastPathComponent(filePath);
        upload.setFilename(filename);
        File localFile = new File(filePath);
        String hash = null;
        try {
            Logger.debug("Performing MD5 checksum on " + filePath + " ...");
            hash = FileUtil.md5Hex(localFile);
        }
        catch (FileNotFoundException fnfe) {
            Logger.error("An error occurred while computing the MD5 checksum.  The file " + filename + " was not found.");
            throw fnfe;
        }
        catch (IOException ioe) {
            Logger.error("An error occurred while computing the MD5 checksum for the file " + filename, ioe);
            throw ioe;
        }
        catch (NoSuchAlgorithmException nsae) {
            Logger.error("An error occurred while computing the MD5 checksum for the file " + filename + ".  The MD5 algorithm could not be found.", nsae);
            throw nsae;
        }
        catch (RuntimeException t) {
            Logger.error("An error occurred while computing the MD5 checksum for the file " + filename, t);
            throw t;
        }
        upload.setChecksum(hash);
        upload.setSize(localFile.length());
        return upload;
    }

    private List<String> convertToStringCollection(Object[] rawKeys) {
        if (rawKeys == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        for (Object key : rawKeys) {
            results.add((String)key);
        }
        return results;
    }

    private boolean displayReturnValue(Map<String, ? extends Object> returnValue, PrintStream stream) {
        Object[] rawKeys = (Object[])returnValue.get(RETURN_DICT__DISPLAY_KEYS_KEY);
        Map attributes = (Map)returnValue.get(RETURN_DICT__ATTRIBUTES_KEY);
        List<String> keys = this.convertToStringCollection(rawKeys);
        String filename = "the upload";
        try {
            filename = this.getUploadFilename();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        stream.println("\n\nSummary for " + filename + ":\n");
        if (keys == null) {
            return true;
        }
        for (String key : keys) {
            String value = (String)attributes.get(key);
            stream.println("\t" + key + ": " + value);
        }
        stream.println();
        return true;
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        OptionHelper.addAuthenticationOptions(options, true, includeHidden);
        options.addOption((Option)new PackageSourceFolderOption());
        return options;
    }
}

