/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.jingle.leghorn.fileformat.Verifier;
import com.apple.transporter.Application;
import com.apple.transporter.ErrorMessageCollector;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.arg.AssetDescriptions;
import com.apple.transporter.foundation.Notification;
import com.apple.transporter.foundation.NotificationCenter;
import com.apple.transporter.log.Logger;
import com.apple.transporter.log.NetworkStatusReporter;
import com.apple.transporter.log.VerifyProgressReporter;
import com.apple.transporter.model.ITMSPackage;
import com.apple.transporter.model.PackageResult;
import com.apple.transporter.model.TransferTestITMSPackage;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.AsperaLoggingLevelOption;
import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.ChaptersXMLValidationOption;
import com.apple.transporter.operation.option.ChecksumValidationOption;
import com.apple.transporter.operation.option.DisableAsperaRegistryCheckOption;
import com.apple.transporter.operation.option.DisableAssetVerificationOption;
import com.apple.transporter.operation.option.DisableTransportEncryptionOption;
import com.apple.transporter.operation.option.EnumeratedValueOption;
import com.apple.transporter.operation.option.ErrorLogDestinationOption;
import com.apple.transporter.operation.option.IndicatorOption;
import com.apple.transporter.operation.option.NumericOption;
import com.apple.transporter.operation.option.OptionHelper;
import com.apple.transporter.operation.option.OutputFormatOption;
import com.apple.transporter.operation.option.PackageSourceFolderOption;
import com.apple.transporter.operation.option.SigniantLoggingLevelOption;
import com.apple.transporter.operation.option.SummaryFileOption;
import com.apple.transporter.operation.option.TrueFalseOption;
import com.apple.transporter.operation.option.VerifyProgressOption;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.LeghornUtil;
import com.apple.transporter.util.NSPathUtilities;
import com.apple.transporter.util.ThroughputUtil;
import com.apple.transporter.util.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;

public class Verify
extends Operation {
    public static final String VERIFY_MODE_VALUE = "verify";
    public static final String PackageUploadSucceededNotification = "PackageUploadSucceeded";
    public static final String PackageUploadFailedNotification = "PackageUploadFailed";
    public static final String PackageProcessingWillStartNotification = "PackageProcessingWillStart";
    public static final String UploadMayRetry = "UploadMayRetry";
    protected static VerifyProgressReporter vpr = new VerifyProgressReporter();

    public Verify(WebService service) {
        super(service);
        vpr.setPhase("Verify");
    }

    @Override
    public boolean execute() {
        boolean wasSuccessful = false;
        ErrorMessageCollector.sharedInstance().setupToCollectErrorMessagesForPackages();
        String packagePath = System.getProperty("f");
        try {
            packagePath = FileUtil.absolutePathForPath(packagePath);
        }
        catch (IOException ioe) {
            Logger.error("Could not get the full package path.  Cannot proceed.", ioe);
            return false;
        }
        File itmsPackageFolder = new File(packagePath);
        itmsPackageFolder = itmsPackageFolder.getAbsoluteFile();
        if (itmsPackageFolder.exists()) {
            wasSuccessful = this.performRequest(packagePath);
        } else {
            Logger.error("Path specified for argument -f (" + packagePath + ") is invalid.");
            Logger.debug("  full path: " + itmsPackageFolder.getAbsolutePath());
        }
        return wasSuccessful;
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        OptionHelper.addAuthenticationOptions(options, false, includeHidden);
        options.addOption((Option)new PackageSourceFolderOption());
        options.addOption((Option)new OutputFormatOption());
        options.addOption((Option)new ErrorLogDestinationOption());
        options.addOption((Option)new VerifyProgressOption(vpr));
        this.addModeSpecificOptions(options);
        if (includeHidden) {
            options.addOption((Option)new DisableTransportEncryptionOption());
            options.addOption((Option)new DisableAsperaRegistryCheckOption());
            options.addOption((Option)new IndicatorOption());
            options.addOption((Option)new ChecksumValidationOption());
            options.addOption((Option)new ChaptersXMLValidationOption());
            options.addOption((Option)new SummaryFileOption());
            options.addOption((Option)new OutputFormatOption());
            options.addOption((Option)new NumericOption("chunkSize"));
            options.addOption((Option)new TrueFalseOption("encryption"));
            options.addOption((Option)new TrueFalseOption("fileChunking"));
            options.addOption((Option)new SigniantLoggingLevelOption());
            options.addOption((Option)new AsperaLoggingLevelOption());
            options.addOption((Option)new TrueFalseOption("fileSizeComparison"));
            options.addOption((Option)new NumericOption("numberOfRetries"));
            options.addOption((Option)new EnumeratedValueOption("mount", new String[]{"mount1", "mount2", "mount3", "mount4"}));
            options.addOption((Option)new BaseOption("pod", true));
            options.addOption((Option)new BaseOption("host", true));
            options.addOption((Option)new BaseOption("relay", true));
        }
        return options;
    }

    protected void addModeSpecificOptions(Options options) {
        options.addOption((Option)new DisableAssetVerificationOption());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean performRequest(String packagePath) {
        Logger.info("Verify mode selected.");
        ArrayList<PackageResult> packageResults = new ArrayList<PackageResult>();
        packageResults.addAll(Verify.dealWithIgnorablePackagesInPackagePath(packagePath, true));
        List<File> files = ITMSPackage.validItmspFilesForDirectoryPath(packagePath);
        Iterator<File> filesEnum = null;
        if (files != null) {
            filesEnum = files.iterator();
        }
        while (filesEnum != null && filesEnum.hasNext()) {
            File aPkgFile = filesEnum.next();
            boolean success = false;
            Logger.startLogFileForPackage(aPkgFile);
            NotificationCenter.defaultCenter().postNotification(PackageProcessingWillStartNotification, aPkgFile, null);
            vpr.resetVerifyCount();
            try {
                final ITMSPackage aPkg = Verify.itmsPackageForPackageFile(aPkgFile, "verified");
                if (aPkg == null) {
                    packageResults.add(Verify.packageFailed(aPkgFile.getPath(), false, false));
                    continue;
                }
                Logger.info("Performing verification of package " + aPkg.packageName() + "...");
                final NetworkStatusReporter netstat = new NetworkStatusReporter("Analyzing metadata", vpr);
                Map returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map>(){

                    @Override
                    public void setNetworkIsReachable(boolean isReachable) {
                        netstat.logReachability(isReachable);
                    }

                    @Override
                    public Map invoke() {
                        return Verify.this.service.verifyOperation(aPkg, Application.shouldHidePassword(), null);
                    }
                });
                vpr.incrementVerifyCountBy(1);
                if (Verify.checkVerifyReturnValueForErrors(packageResults, aPkgFile, aPkg, returnValue)) continue;
                if (!this.postAuthenticatePackageValidation(returnValue, aPkg)) {
                    packageResults.add(Verify.packageFailed(aPkgFile.getPath(), false, false));
                    continue;
                }
                if (System.getProperty("disableAssetVerification") == null) {
                    vpr.incrementVerifyCount();
                    Collection<Map<String, Object>> assetDescriptions = Verify.describeAssets(aPkg, returnValue);
                    final AssetDescriptions descriptions = new AssetDescriptions(assetDescriptions);
                    final NetworkStatusReporter innerNetstat = new NetworkStatusReporter("Validating assets", vpr);
                    returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map>(){

                        @Override
                        public void setNetworkIsReachable(boolean isReachable) {
                            innerNetstat.logReachability(isReachable);
                        }

                        @Override
                        public Map invoke() {
                            return Verify.this.service.verifyOperation(aPkg, Application.shouldHidePassword(), descriptions);
                        }
                    });
                    if (Verify.checkVerifyReturnValueForErrors(packageResults, aPkgFile, aPkg, returnValue)) {
                        vpr.logVerifyProgress("Operation failed");
                        continue;
                    }
                }
                Logger.info("The package " + aPkg.packageNameWithPath() + " has been successfully verified.");
                packageResults.add(Verify.packageSucceeded(aPkgFile.getPath(), 0L, 0L, false));
                vpr.logVerifyProgress("Operation completed");
                success = true;
            }
            catch (Throwable t) {
                Logger.error("Error while processing package " + aPkgFile.getName() + ".", t);
                packageResults.add(Verify.packageFailed(aPkgFile.getPath(), false, false));
            }
            finally {
                Logger.cleanupLogFileForPackage(success);
            }
        }
        Application.displayWarningMessages();
        Application.displayInfoMessages();
        if (Application.shouldGenerateXML()) {
            Verify.showPackageOperationResultsXML(packageResults);
        } else {
            Verify.showPackageOperationResults(packageResults, "verified");
        }
        return !Verify.hasFailedOrIgnoredPackages(packageResults);
    }

    protected static boolean hasFailedOrIgnoredPackages(List<PackageResult> packageResults) {
        for (PackageResult packageResult : packageResults) {
            if (packageResult.getStatus() != PackageResult.Status.Failure && packageResult.getStatus() != PackageResult.Status.Ignored) continue;
            return true;
        }
        return false;
    }

    protected static ITMSPackage itmsPackageForPackageFile(File aPkgFile, String modeVerb) {
        ITMSPackage aPkg;
        if (aPkgFile == null || modeVerb == null) {
            return null;
        }
        try {
            aPkg = Application.isTestTransferMode() ? new TransferTestITMSPackage(aPkgFile) : new ITMSPackage(aPkgFile);
        }
        catch (IOException ioe) {
            Logger.error("The itms package " + aPkgFile.getName() + " has problems.", ioe);
            aPkg = null;
        }
        catch (Throwable t) {
            Logger.error("The itms package " + aPkgFile.getName() + " has problems.", t);
            aPkg = null;
        }
        if (aPkg == null) {
            return null;
        }
        Logger.info("Examining the package at: " + aPkg.packageNameWithPath());
        Logger.info("Ensuring that package has well formed metadata file...");
        if (!aPkg.isMetadataWellFormed()) {
            Logger.error("The package:  " + aPkg.packageName() + " will NOT be " + modeVerb + ".");
            return null;
        }
        return aPkg;
    }

    protected static PackageResult packageFailed(String aPkgName, boolean isForUpload, boolean mayRetry) {
        if (aPkgName == null || aPkgName.length() == 0) {
            return null;
        }
        if (isForUpload) {
            NotificationCenter defaultCenter = NotificationCenter.defaultCenter();
            Notification notification = new Notification(PackageUploadFailedNotification, aPkgName, null);
            notification.getUserInfo().put(UploadMayRetry, mayRetry);
            defaultCenter.postNotification(notification);
        }
        PackageResult result = new PackageResult(aPkgName, PackageResult.Status.Failure);
        return result;
    }

    protected static PackageResult packageSucceeded(String aPkgName, long durationMillis, long bytesTransferred, boolean isForUpload) {
        if (aPkgName == null || aPkgName.length() == 0) {
            return null;
        }
        if (isForUpload) {
            NotificationCenter defaultCenter = NotificationCenter.defaultCenter();
            defaultCenter.postNotification(PackageUploadSucceededNotification, aPkgName, null);
        }
        PackageResult result = durationMillis > 0L ? new PackageResult(aPkgName, PackageResult.Status.Success, durationMillis, bytesTransferred) : new PackageResult(aPkgName, PackageResult.Status.Success);
        return result;
    }

    protected boolean postAuthenticatePackageValidation(Map authReturnValue, ITMSPackage aPkg) {
        String chaptersSchema;
        Map schemasToValidate;
        Map remoteFileSizes;
        if (authReturnValue == null) {
            return false;
        }
        if (aPkg == null) {
            return false;
        }
        if (Application.shouldDoAssetReplacementVerification()) {
            Logger.info("The asset replacement verification check is enabled.");
            Object[] assetNamesToBeReplaced = (Object[])authReturnValue.get(System.getProperty("AssetNamesToBeReplacedKey"));
            if (assetNamesToBeReplaced != null) {
                String assetNamesString = StringUtils.join((Object[])assetNamesToBeReplaced, (String)", ");
                Logger.error("The package " + aPkg.packageName() + " will not be uploaded because the following files in the package would replace existing assets: " + assetNamesString);
                return false;
            }
        } else {
            Logger.info("The asset replacement verification check is disabled.");
        }
        if (System.getProperty("disableAssetVerification") == null && !aPkg.validateFileSizes(remoteFileSizes = (Map)authReturnValue.get(System.getProperty("fileSizesKey")))) {
            return false;
        }
        if (Application.shouldValidateChaptersXML() && (schemasToValidate = (Map)authReturnValue.get(System.getProperty("schemasToValidateKey"))) != null && (chaptersSchema = (String)schemasToValidate.get(System.getProperty("chaptersSchemaKey"))) != null && !aPkg.validateChaptersXML(chaptersSchema)) {
            return false;
        }
        if (System.getProperty("disableAssetVerification") == null) {
            Map remoteChecksums = (Map)authReturnValue.get(System.getProperty("checksumsKey"));
            Boolean checksumCompleted = (Boolean)authReturnValue.get(System.getProperty("checksumCompletedFlagKey"));
            if (checksumCompleted == null) {
                checksumCompleted = false;
            }
            Map fileLastModifiedTimestamps = (Map)authReturnValue.get(System.getProperty("fileLastModifiedKey"));
            boolean areChecksumsValid = true;
            if (Application.shouldPerformChecksum()) {
                areChecksumsValid = aPkg.validateFileChecksums(remoteChecksums, (Number)authReturnValue.get(System.getProperty("MinimumFileSizeThresholdForCheckumKey")), checksumCompleted, fileLastModifiedTimestamps, this.service);
            }
            if (!areChecksumsValid) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Collection<Map<String, Object>> describeAssets(ITMSPackage aPackage, Map returnValue) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Object[] assetsToDescribe = (Object[])returnValue.get(System.getProperty("assetsToDescribeKey"));
        if (assetsToDescribe != null && assetsToDescribe.length != 0) {
            LeghornUtil.begin();
            try {
                Verifier verifier;
                if (!aPackage.supportsAssetDescription()) return result;
                Logger.info("Starting media analysis of assets");
                vpr.incrementVerifyCountBy(assetsToDescribe.length);
                try {
                    verifier = Verifier.getDefaultVerifier();
                }
                catch (Exception e) {
                    Logger.error("Cannot obtain Verifier instance; aborting media analysis", e);
                    ArrayList<Map<String, Object>> arrayList = result;
                    LeghornUtil.end();
                    return arrayList;
                }
                for (Object obj : assetsToDescribe) {
                    Map params = (Map)obj;
                    String filename = (String)params.get(System.getProperty("assetsToDescribeKey.Filename"));
                    String uti = (String)params.get(System.getProperty("assetsToDescribeKey.UTI"));
                    String role = (String)params.get(System.getProperty("assetsToDescribeKey.Role"));
                    boolean shouldDescribeAsset = Boolean.parseBoolean((String)params.get(System.getProperty("assetsToDescribeKey.ShouldDescribeAsset")));
                    Logger.debug("Handling asset: filename=" + filename + ",uti=" + uti + ",role=" + role + ",describe=" + shouldDescribeAsset);
                    if (!shouldDescribeAsset) continue;
                    vpr.logVerifyProgress("Adding asset to analyze:", filename);
                    Map<String, Object> mdr = LeghornUtil.describeAsset(verifier, filename, NSPathUtilities.stringByAppendingPathComponent(aPackage.packageNameWithPath(), filename), uti, role, true);
                    result.add(mdr);
                }
                Logger.info("Asset media analysis has completed");
                return result;
            }
            finally {
                LeghornUtil.end();
            }
        }
        Logger.info("Nothing to describe for media analysis of assets");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void showPackageOperationResultsXML(List<PackageResult> packageResults) {
        ErrorMessageCollector errorMsgCollector = ErrorMessageCollector.sharedInstance();
        XMLUtil.XMLTag summaryRoot = new XMLUtil.XMLTag("summary", 1);
        try {
            summaryRoot.addAttribute("mode", System.getProperty("m"));
            block7: for (PackageResult packageResult : packageResults) {
                List<String> infoMessages;
                XMLUtil.XMLTag packageTag = summaryRoot.addChildTag("package");
                packageTag.addAttribute("path", packageResult.getPath());
                List<String> warnMessages = errorMsgCollector.warningMessagesForPackageNamed(packageResult.getPath());
                if (warnMessages != null && warnMessages.size() > 0) {
                    for (String string : warnMessages) {
                        packageTag.addChildTag(XMLUtil.generateLogTag(2, Logger.Level.Warn, string));
                    }
                }
                if ((infoMessages = errorMsgCollector.infoMessagesForPackageNamed(packageResult.getPath())) != null && infoMessages.size() > 0) {
                    for (String info : infoMessages) {
                        packageTag.addChildTag(XMLUtil.generateLogTag(2, Logger.Level.Info, info));
                    }
                }
                switch (packageResult.getStatus()) {
                    case Success: {
                        packageTag.addAttribute("status", "success");
                        if (!Application.shouldDisplayThroughput()) continue block7;
                        packageTag.addAttribute("duration_ms", String.valueOf(packageResult.getDurationMillis()));
                        break;
                    }
                    case Failure: {
                        packageTag.addAttribute("status", "failure");
                        List<String> list = errorMsgCollector.errorMessagesForPackageNamed(packageResult.getPath());
                        if (list == null || list.size() <= 0) continue block7;
                        for (String error : list) {
                            packageTag.addChildTag(XMLUtil.generateLogTag(2, Logger.Level.Error, error));
                        }
                        continue block7;
                    }
                    default: {
                        Logger.error("unanticipated package result status: " + (Object)((Object)packageResult.getStatus()));
                    }
                }
            }
        }
        finally {
            String xml = summaryRoot.marshall();
            Application.writeSummary(xml);
        }
    }

    protected static void showPackageOperationResults(List<PackageResult> packageResults, String modeVerb) {
        if (packageResults == null) {
            return;
        }
        String separatorString = "\n\t";
        Application.writeSummary("\n\n\nPackage Summary:\n");
        int successCount = 0;
        int failureCount = 0;
        int ignoredCount = 0;
        StringBuilder allSuccessfulPaths = new StringBuilder();
        StringBuilder allIgnoredPaths = new StringBuilder();
        for (PackageResult packageResult : packageResults) {
            switch (packageResult.getStatus()) {
                case Success: {
                    ++successCount;
                    if (allSuccessfulPaths.length() != 0) {
                        allSuccessfulPaths.append(separatorString);
                    }
                    allSuccessfulPaths.append(packageResult.getPath());
                    break;
                }
                case Failure: {
                    ++failureCount;
                    break;
                }
                case Ignored: {
                    ++ignoredCount;
                    if (allIgnoredPaths.length() != 0) {
                        allIgnoredPaths.append(separatorString);
                    }
                    allIgnoredPaths.append(packageResult.getPath());
                }
            }
        }
        if (successCount > 0) {
            Application.writeSummary(" \n");
            Application.writeSummary(successCount + " packages were " + modeVerb + " successfully:" + separatorString + allSuccessfulPaths.toString() + "\n");
        }
        if (Application.shouldDisplayThroughput() && successCount > 0) {
            Application.writeSummary(" \n");
            Application.writeSummary("The successful package(s) throughput information is:\n");
            for (PackageResult packageResult : packageResults) {
                if (packageResult.getStatus() != PackageResult.Status.Success) continue;
                Application.writeSummary("\t" + packageResult.getPath() + "\t\t\t" + Verify.getDurationMillisAsStringForPackageResult(packageResult) + ", " + Verify.getBytesTransferredStringForPackageResult(packageResult) + ", " + Verify.getThroughputPerSecondStringForPackageResult(packageResult) + "\n");
            }
        }
        if (failureCount > 0) {
            Application.writeSummary(" \n");
            Application.writeSummary(failureCount + " package(s) were not " + modeVerb + " because they had problems:\n");
            ErrorMessageCollector errorMsgCollector = ErrorMessageCollector.sharedInstance();
            for (PackageResult packageResult : packageResults) {
                String pkgName = packageResult.getPath();
                List<String> errorMessages = errorMsgCollector.errorMessagesForPackageNamed(pkgName);
                if (errorMessages == null || errorMessages.size() <= 0) continue;
                String allErrorMessages = Verify.joinStrings(errorMessages, "\n\t\t");
                Application.writeSummary("\t" + pkgName + " - Error Messages:\n\t\t" + allErrorMessages + "\n");
            }
        }
        if (ignoredCount > 0) {
            Application.writeSummary(" \n");
            Application.writeSummary(ignoredCount + " packages were not " + modeVerb + " because they were not valid and thus ignored:" + separatorString + allIgnoredPaths + "\n");
        }
    }

    protected static List<PackageResult> dealWithIgnorablePackagesInPackagePath(String packagePath, boolean doPostUploadNotification) {
        ArrayList<PackageResult> ignoredPackages = new ArrayList<PackageResult>();
        if (packagePath == null || packagePath.length() == 0) {
            return ignoredPackages;
        }
        List<File> invalidItmspFiles = ITMSPackage.invalidItmspFilesForDirectoryPath(packagePath);
        if (invalidItmspFiles == null || invalidItmspFiles.size() == 0) {
            return ignoredPackages;
        }
        ArrayList<String> invalidItmspFilePaths = new ArrayList<String>();
        for (File file : invalidItmspFiles) {
            invalidItmspFilePaths.add(file.getPath());
        }
        ListIterator invalidEnum = null;
        if (invalidItmspFilePaths != null) {
            invalidEnum = invalidItmspFilePaths.listIterator();
        }
        while (invalidEnum != null && invalidEnum.hasPrevious()) {
            String aPath = (String)invalidEnum.previous();
            if (doPostUploadNotification) {
                Verify.packageFailed(aPath, doPostUploadNotification, false);
            }
            ignoredPackages.add(new PackageResult(aPath, PackageResult.Status.Ignored));
        }
        return ignoredPackages;
    }

    private static String joinStrings(List<String> messages, String string) {
        if (messages == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        boolean added = false;
        for (String message : messages) {
            if (added) {
                builder.append(string);
            }
            builder.append(message);
            added = true;
        }
        return builder.toString();
    }

    private static boolean checkVerifyReturnValueForErrors(List<PackageResult> packageResults, File aPkgFile, ITMSPackage aPkg, Map returnValue) {
        if (returnValue == null) {
            Application.logUnnecessaryError("Unable to verify the package: " + aPkg.packageName());
            packageResults.add(Verify.packageFailed(aPkgFile.getPath(), false, false));
            return true;
        }
        if (Application.doesContainSOAPError(returnValue)) {
            Application.logUnnecessaryError("Unable to verify the package: " + aPkg.packageName());
            Application.displaySOAPErrorMessages(returnValue);
            packageResults.add(Verify.packageFailed(aPkgFile.getPath(), false, false));
            return true;
        }
        return false;
    }

    private static String getBytesTransferredStringForPackageResult(PackageResult packageResult) {
        if (packageResult == null) {
            return "";
        }
        return ThroughputUtil.getBytesAsString(packageResult.getBytesTransferred());
    }

    private static String getThroughputPerSecondStringForPackageResult(PackageResult packageResult) {
        if (packageResult == null) {
            return "";
        }
        return ThroughputUtil.getThroughputPerSecondString(packageResult.getDurationMillis(), packageResult.getBytesTransferred());
    }

    private static String getDurationMillisAsStringForPackageResult(PackageResult packageResult) {
        if (packageResult == null) {
            return "";
        }
        return ThroughputUtil.getDurationMillisAsString(packageResult.getDurationMillis());
    }
}

