/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.jingle.leghorn.fileformat.Verifier;
import com.apple.transporter.ErrorMessageCollector;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.arg.AssetDescriptions;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.AssetFileOption;
import com.apple.transporter.operation.option.AssetFolderOption;
import com.apple.transporter.operation.option.FailureOption;
import com.apple.transporter.operation.option.OptionHelper;
import com.apple.transporter.operation.option.SuccessOption;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.LeghornUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class ValidateRawAssets
extends Operation {
    public static final String MODE_VALUE = "validateRawAssets";

    public ValidateRawAssets(WebService service) {
        super(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        ErrorMessageCollector.sharedInstance().setupToCollectErrorMessagesForNonPackageBasedModes();
        Logger.info("Performing validation of raw assets ...");
        List<File> filesToDescribe = this.scanAssets();
        if (filesToDescribe == null || filesToDescribe.isEmpty()) {
            Logger.info("No asset files found; nothing to do.");
            return true;
        }
        final ArrayList<String> fileNames = new ArrayList<String>();
        for (File file : filesToDescribe) {
            fileNames.add(file.getName());
        }
        Map results = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map>(){

            @Override
            public void setNetworkIsReachable(boolean isReachable) {
            }

            @Override
            public Map invoke() {
                return ValidateRawAssets.this.service.queryAssetTypes(fileNames);
            }
        });
        if (results == null) {
            return false;
        }
        Map assetsToDescribe = (Map)results.get(System.getProperty("assetsToDescribeKey"));
        if (assetsToDescribe != null && !assetsToDescribe.isEmpty()) {
            ArrayList<Map<String, Object>> assetDescriptions = new ArrayList<Map<String, Object>>();
            LeghornUtil.begin();
            try {
                boolean noErrors;
                Verifier verifier;
                Logger.info("Starting media analysis of assets");
                try {
                    verifier = Verifier.getDefaultVerifier();
                }
                catch (Exception e) {
                    Logger.error("Cannot obtain Verifier instance; aborting media analysis", e);
                    boolean bl = false;
                    LeghornUtil.end();
                    return bl;
                }
                for (Object obj : assetsToDescribe.keySet()) {
                    String filename = (String)obj;
                    String uti = (String)assetsToDescribe.get(filename);
                    Logger.debug("Handling asset: filename=" + filename + ",uti=" + uti);
                    try {
                        Map<String, Object> mdr = LeghornUtil.describeAsset(verifier, filename, new File(this.assetFolder(), filename).getPath(), uti, null, false);
                        assetDescriptions.add(mdr);
                    }
                    catch (IOException e) {
                        Logger.error("Could not describe file: " + filename, e);
                    }
                }
                Logger.info("Asset media analysis has completed");
                final AssetDescriptions descriptions = new AssetDescriptions(assetDescriptions);
                results = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map>(){

                    @Override
                    public void setNetworkIsReachable(boolean isReachable) {
                    }

                    @Override
                    public Map invoke() {
                        return ValidateRawAssets.this.service.validateRawAssets(descriptions);
                    }
                });
                if (results == null) {
                    boolean obj = false;
                    return obj;
                }
                File assetFolder = null;
                File successFolder = null;
                File failureFolder = null;
                try {
                    assetFolder = this.assetFolder();
                    if (System.getProperty("success") != null) {
                        successFolder = new File(FileUtil.absolutePathForPath(System.getProperty("success")));
                        successFolder.mkdirs();
                    }
                    if (System.getProperty("failure") != null) {
                        failureFolder = new File(FileUtil.absolutePathForPath(System.getProperty("failure")));
                        failureFolder.mkdirs();
                    }
                }
                catch (IOException e) {
                    Logger.error("Failed to set-up success or failure folder", e);
                }
                Map validationResults = (Map)results.get("RawAssetValidationResults");
                boolean bl = noErrors = this.showResultsSummary(assetFolder, successFolder, failureFolder, validationResults);
                return bl;
            }
            finally {
                LeghornUtil.end();
            }
        }
        Logger.info("Nothing to describe for media analysis of assets");
        return false;
    }

    private boolean showResultsSummary(File assetFolder, File successFolder, File failureFolder, Map validationResults) {
        ArrayList<String> fileNamesList = new ArrayList<String>();
        HashMap warningsMap = new HashMap();
        HashMap errorsMap = new HashMap();
        int warningCount = 0;
        int errorCount = 0;
        if (validationResults != null) {
            for (Object key : validationResults.keySet()) {
                File dest;
                File src;
                String filename = (String)key;
                fileNamesList.add(filename);
                Object[] errorsAndWarnings = (Object[])validationResults.get(key);
                Object[] errors = (Object[])errorsAndWarnings[0];
                Object[] warnings = (Object[])errorsAndWarnings[1];
                ArrayList<Object> errorsList = new ArrayList<Object>();
                ArrayList<Object> warningsList = new ArrayList<Object>();
                if (warnings != null && warnings.length > 0) {
                    ++warningCount;
                    warningsList.addAll(Arrays.asList(warnings));
                }
                if (errors != null && errors.length > 0) {
                    ++errorCount;
                    errorsList.addAll(Arrays.asList(errors));
                    if (assetFolder != null && failureFolder != null && !(src = new File(assetFolder, filename)).renameTo(dest = new File(failureFolder, filename))) {
                        Logger.warn("Failed to move file from " + src.getPath() + " to " + dest.getPath());
                    }
                } else if (assetFolder != null && successFolder != null && !(src = new File(assetFolder, filename)).renameTo(dest = new File(successFolder, filename))) {
                    Logger.warn("Failed to move file from " + src.getPath() + " to " + dest.getPath());
                }
                warningsMap.put(filename, warningsList);
                errorsMap.put(filename, errorsList);
            }
        }
        int noErrorCount = fileNamesList.size() - errorCount;
        String lineSep = System.getProperty("line.separator");
        Logger.essential(lineSep + lineSep + "Summary");
        if (noErrorCount > 0) {
            Logger.essential(lineSep + (fileNamesList.size() - errorCount) + " asset" + (noErrorCount == 1 ? " was" : "s were") + " validated successfully" + (warningCount > 0 ? " (with warnings):" : ":"));
            for (String filename : fileNamesList) {
                if (!((List)errorsMap.get(filename)).isEmpty()) continue;
                Logger.essential("\t" + filename);
                for (Object warning : (List)warningsMap.get(filename)) {
                    Logger.essential("\t\t" + warning);
                }
            }
        }
        if (errorCount > 0) {
            Logger.essential(lineSep + errorCount + " asset" + (errorCount == 1 ? " was" : "s were") + " not validated successfully because " + (errorCount == 1 ? "it" : "they") + " had problems:");
            for (String filename : fileNamesList) {
                if (((List)errorsMap.get(filename)).isEmpty()) continue;
                Logger.essential("\t" + filename);
                for (Object error : (List)errorsMap.get(filename)) {
                    Logger.essential("\t\t" + error);
                }
            }
        }
        Logger.essential(lineSep);
        return errorCount == 0;
    }

    private List<File> scanAssets() {
        try {
            RegexFileFilter fileFilter = new RegexFileFilter();
            File[] result = null;
            File assetFile = this.assetFile();
            if (assetFile != null) {
                if (fileFilter.accept(assetFile)) {
                    result = new File[]{assetFile};
                } else {
                    Logger.error("The specified file '" + assetFile.getPath() + "' is not supported for asset validation.");
                }
            } else {
                File assetFolder = this.assetFolder();
                result = assetFolder.listFiles(fileFilter);
            }
            if (result == null) {
                return new ArrayList<File>();
            }
            return Arrays.asList(result);
        }
        catch (IOException e) {
            Logger.error("Failed to scan asset folder", e);
            return new ArrayList<File>();
        }
    }

    private File assetFile() throws IOException {
        String path = System.getProperty("assetFile");
        if (path != null) {
            File assetFile = new File(FileUtil.absolutePathForPath(path));
            return assetFile;
        }
        return null;
    }

    private File assetFolder() throws IOException {
        String path = System.getProperty("assetFolder");
        if (path != null) {
            return new File(FileUtil.absolutePathForPath(path));
        }
        return this.assetFile().getParentFile();
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        OptionHelper.addAuthenticationOptions(options, false, includeHidden);
        OptionGroup assetGroup = new OptionGroup();
        assetGroup.setRequired(true);
        AssetFolderOption assetFolderOption = new AssetFolderOption(AssetFolderOption.Variant.Generic);
        assetGroup.addOption((Option)assetFolderOption);
        AssetFileOption assetFileOption = new AssetFileOption(AssetFileOption.Variant.Generic);
        assetGroup.addOption((Option)assetFileOption);
        options.addOptionGroup(assetGroup);
        options.addOption((Option)new SuccessOption("The -success option specifies where to copy successfully validated assets."));
        options.addOption((Option)new FailureOption("The -failure option specifies where to copy unsuccessfully validated assets."));
        return options;
    }

    static class RegexFileFilter
    implements FileFilter {
        final String regex = System.getProperty("validateRawAssetsFilenameFilter");

        RegexFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile() && (this.regex == null || pathname.getPath().matches(this.regex));
        }
    }
}

